oat_analyseAllParams <-
function(FILEPATH,PARAMETERS,BASELINE,PMIN,PMAX,PINC,MEASURES,MEDIANSFILENAME,ATESTRESULTSFILENAME)
{
	# CONSIDER EACH PARAMETER IN TURN
	for(PARAM in 1:length(PARAMETERS))
	{
		# READ IN THE BASELINE VALUES ON WHICH THE ALTERATIONS WILL BE COMPARED
		BASELINEFILE = paste(FILEPATH,"/",PARAMETERS[PARAM],"/",toString(BASELINE[PARAM]),"/",MEDIANSFILENAME,sep="")
		BASELINERESULT <- read.csv(BASELINEFILE,header=TRUE,sep=",")
		
		# NOW COMPARE THE RESULTS FROM THE REST OF THE VALUES SET FOR THIS PARAMETER WITH THE BASELINE USING
		# THE A-TEST
		RESULTS<-NULL
		PARAMVAL<-PMIN[PARAM]
		
		while(PARAMVAL<=PMAX[PARAM])
		{
			# Read in the set to be compared to the BASELINE
			COMPAREDISTFILE<-paste(FILEPATH,"/",PARAMETERS[PARAM],"/",toString(PARAMVAL),
				"/",MEDIANSFILENAME,sep="")	
			
			# NOW LOOK AT EACH MEASURE IN TURN
			ATESTALLMEASURES<-NULL
			ATESTALLMEASURES<-c(PARAMVAL)
	
			for(l in 1:length(MEASURES))
			{
				if(file.exists(COMPAREDISTFILE))
				{
					COMPAREDIST<-read.csv(COMPAREDISTFILE,header=TRUE,sep=",")

					ATESTVAL<- atest(BASELINERESULT[,MEASURES[l]],COMPAREDIST[,MEASURES[l]])
					ATESTNORM<-normaliseATest(ATESTVAL)
		
					# ADD RESULTS FOR THIS SAMPLE TO RESULT VECTOR
					ATESTALLMEASURES<-cbind(ATESTALLMEASURES,ATESTVAL,ATESTNORM)
				}
				else
				{
					ATESTALLMEASURES<-cbind(ATESTALLMEASURES,1,1)
				}			

				
			}
			
			RESULTS<-rbind(RESULTS,ATESTALLMEASURES)
			PARAMVAL<-PARAMVAL+PINC[PARAM]
		}


		# WRITE THE A-TEST RESULTS TO FILE (ATests.csv for 1 timepoint)
		RESULTSFILE = paste(FILEPATH,"/",PARAMETERS[PARAM],"/",ATESTRESULTSFILENAME,sep="")
	
		# GENERATE COLUMN HEADERS FOR EASE OF REFERENCE LATER
		COLHEADERS<-c("ParameterVal")
	
		for(l in 1:length(MEASURES))
		{
			COLHEADERS<-cbind(COLHEADERS,paste("ATest",MEASURES[l],sep=""),paste("ATest",MEASURES[l],"Norm",sep=""))
		}
		colnames(RESULTS)<-c(COLHEADERS)
		
		write.csv(RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
		
	}

}

