% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_spark.R, R/install_spark_versions.R
\name{spark_install_find}
\alias{spark_install_find}
\alias{spark_install}
\alias{spark_uninstall}
\alias{spark_install_dir}
\alias{spark_install_tar}
\alias{spark_installed_versions}
\alias{spark_available_versions}
\title{Find a given Spark installation by version.}
\usage{
spark_install_find(version = NULL, hadoop_version = NULL,
  installed_only = TRUE, latest = FALSE, hint = FALSE)

spark_install(version = NULL, hadoop_version = NULL, reset = TRUE,
  logging = "INFO", verbose = interactive())

spark_uninstall(version, hadoop_version)

spark_install_dir()

spark_install_tar(tarfile)

spark_installed_versions()

spark_available_versions(show_hadoop = FALSE)
}
\arguments{
\item{version}{Version of Spark to install. See \code{spark_available_versions} for a list of supported versions}

\item{hadoop_version}{Version of Hadoop to install. See \code{spark_available_versions} for a list of supported versions}

\item{installed_only}{Search only the locally installed versions?}

\item{latest}{Check for latest version?}

\item{hint}{On failure should the installation code be provided?}

\item{reset}{Attempts to reset settings to defaults.}

\item{logging}{Logging level to configure install. Supported options: "WARN", "INFO"}

\item{verbose}{Report information as Spark is downloaded / installed}

\item{tarfile}{Path to TAR file conforming to the pattern spark-###-bin-(hadoop)?### where ###
reference spark and hadoop versions respectively.}

\item{show_hadoop}{Show Hadoop distributions?}
}
\value{
List with information about the installed version.
}
\description{
Install versions of Spark for use with local Spark connections
  (i.e. \code{spark_connect(master = "local"})
}
\keyword{internal}
