% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_mutate}
\alias{sdf_mutate}
\alias{sdf_mutate_}
\title{Mutate a Spark DataFrame}
\usage{
sdf_mutate(.data, ...)

sdf_mutate_(.data, ..., .dots)
}
\arguments{
\item{.data}{A \code{spark_tbl}.}

\item{...}{Named arguments, mapping new column names to the transformation to
be applied.}

\item{.dots}{A named list, mapping output names to transformations.}
}
\description{
Use Spark's \href{http://spark.apache.org/docs/latest/ml-features.html}{feature transformers}
to mutate a Spark DataFrame.
}
\section{Transforming Spark DataFrames}{


The family of functions prefixed with \code{sdf_} generally access the Scala
Spark DataFrame API directly, as opposed to the \code{dplyr} interface which
uses Spark SQL. These functions will 'force' any pending SQL in a
\code{dplyr} pipeline, such that the resulting \code{tbl_spark} object
returned will no longer have the attached 'lazy' SQL operations. Note that
the underlying Spark DataFrame \emph{does} execute its operations lazily, so
that even though the pending set of operations (currently) are not exposed at
the \R level, these operations will only be executed when you explicitly
\code{collect()} the table.
}

\examples{
\dontrun{
# using the 'beaver1' dataset, binarize the 'temp' column
data(beavers, package = "datasets")
beaver_tbl <- copy_to(sc, beaver1, "beaver")
beaver_tbl \%>\%
  mutate(squared = temp ^ 2) \%>\%
  sdf_mutate(warm = ft_binarizer(squared, 1000)) \%>\%
  sdf_register("mutated")

# view our newly constructed tbl
head(beaver_tbl)

# note that we have two separate tbls registered
dplyr::src_tbls(sc)
}
}
\concept{feature transformation routines}
