HLfit_body <- local({
  #min_phi_warned <- FALSE
  function(processed, 
                       control.HLfit=list(), ## used both by preprocess and HLfit_body
                       init.HLfit = list(), ## not from processed: this is affected by HLCor_body -> .canonizeRanPars(ranPars) post .preprocess()ing
                       #                       Thus if in a HLCor call we can expect a $corrPars in sp3 code.
                       ranFix=list(), ## phi, lambda, possibly nu, rho if not in init.HLfit
                       etaFix=list() ## beta, v_h (or even u_h)
) {
  data <- processed$data
  verbose <- processed$verbose
  family <- processed$family
  ranFix <- .post_process_family(family,ranFix) ## assign 'extra' pars and cleans ranFix
  ranFix <- .canonizeRanPars(ranPars=ranFix,corr_info=NULL, checkComplete = FALSE)## including full-size lambda
  formula <- processed$predictor
  prior.weights <- processed$prior.weights
  
  warningList <- list()
  ## when adding verbose elements, remind that these might be lost through corrHLfit -> HLCor cf dotlist$verbose <- verbose[intersect(...]
  ##
  nobs <- nrow(data) ## before prior.weights is evaluated
  predictor <- processed$predictor
  rand.families <- processed$rand.families
  lcrandfamfam <- attr(rand.families,"lcrandfamfam")
  HL <- processed$HL
  stop.on.error <- processed$stop.on.error ## to control issues with matrix computations; F by default
  spaMM_tol <- processed$spaMM_tol
  iter.mean.dispFix <- processed$iter.mean.dispFix
  iter.mean.dispVar <- processed$iter.mean.dispVar
  max.iter <- processed$max.iter
  BinomialDen <- processed$BinomialDen
  y <- processed$y
  REMLformula <- processed$REMLformula ## should no longer be modified
  #X.pv <- processed$AUGI0_ZX$X.pv
  X.Re <- processed$`X.Re` ## should be NULL _xor_ distinct from X.pv
  ### a bit of post processing
  nobs <- NROW(processed$AUGI0_ZX$X.pv)
  pforpv <- ncol(processed$AUGI0_ZX$X.pv)
  LMMbool <- processed$LMMbool
  models <- processed$models
  #### Note that HLCor modifies the L matrix (inprocessed$predictor if required) => ZAL cannot be preprocessed by corHLfit and must be recomputed each time 
  ZAlist <- processed$ZAlist ## : ZAlist is a list of design matrices 
  nrand <- length(ZAlist)
  cum_n_u_h <- processed$cum_n_u_h
  n_u_h <- cum_n_u_h[nrand+1L] 
  vec_n_u_h <- diff(cum_n_u_h)
  if (models[["eta"]]=="etaHGLM") {
    sparse_precision <- processed$sparsePrecisionBOOL
    ranCoefs.Fix <- .getPar(ranFix,"ranCoefs") ## may be NULL
    ranCoefs_blob <- .process_ranCoefs(processed, ranCoefs.Fix,use_tri=TRUE) ## UPDATES preexisting object # no augZXy pb here
    LMatrices <- processed$AUGI0_ZX$envir$LMatrices
    # HLCor_body has prefilled $LMatrices for :
    #    for Matern...
    # or for CAR, when HLCor_body has updated LMatrix as fn of rho: seek adjd usage]
    # or was copied from attr(predictor,"LMatrix")
    ### we add the ranCoefs matrices:
    if (any(ranCoefs_blob$is_set)) {
      LMatrices[ranCoefs_blob$is_set] <- ranCoefs_blob$LMatrices[ranCoefs_blob$is_set]
      attr(LMatrices,"is_given_by")[ranCoefs_blob$is_set] <- "ranCoefs"
      # lambda_est initialized from ranCoefs_blob later !
    }
    if (processed$sparsePrecisionBOOL) { 
      which_inner_ranCoefs <- which(ranCoefs_blob$isRandomSlope & ( ! ranCoefs_blob$is_set))
      attr(LMatrices,"is_given_by")[which_inner_ranCoefs] <- "inner_ranCoefs"
      .init_precision_info(processed,LMatrices) ## modifies processed$AUGI0_ZX$envir  
    }
    if ( any((attr(LMatrices,"is_given_by") !="")) ) {
      ZAL <- .compute_ZAL(XMatrix=LMatrices, ZAlist=ZAlist,as_matrix=.eval_as_mat_arg(processed))
      ## ZAL may be modified by other call to .compute_ZAL()   
    } else { 
      ZAL <- processed$AUGI0_ZX$ZAfix ## default ZA 
    } 
  } else if (models[[1]]=="etaGLM") {
    ZAL <- NULL ## 
    u_h <- v_h <- lev_lambda <- numeric(0)
  }
  lambda.Fix <- ranFix$lambda # .getPar(ranFix,"lambda") ## should already have length 'nrand' or else be NULL
  if (is.null(lambda.Fix)) lambda.Fix <- rep(NA,nrand) ## FIXME: put in canonizeRanpars ? depends onother uses of this fn.
  if (any(lambda.Fix[!is.na(lambda.Fix)]==0)) stop("lambda cannot be fixed to 0.")
  ###
  off <- processed$off
  ##################
  unknowns <- setdiff(names(init.HLfit),c("fixef","phi","lambda","v_h","rho","nu","Nugget","ARphi","corrPars","ranCoefs")) ## in spaMM 3.0 several names should disappear   
    if (length(unknowns)) {
      if ("beta" %in% unknowns) message("  Use 'fixef' rather than 'beta' in 'init.HLfit'.")
      stop("unhandled elements in 'init.HLfit'.")
    }
  ###################
  HLfit_corrPars <- init.HLfit$corrPars 
  corr_est <- .get_cP_stuff(init.HLfit,"rho") ## not spaMM 3.0## init.HLfit[intersect(c("nu","rho","Nugget","ARphi"),names(init.HLfit))]
  if (! is.null(corr_est)) {
    corr_est <- list(rho=corr_est) ## not yet spaMM 3.0 
    corrEstBlob <- .eval_corrEst_args(family=family,rand.families=rand.families,predictor=predictor,data=data,X.Re=X.Re,
                                     REMLformula=REMLformula,ranFix=ranFix,
                                     Optimizer=control.HLfit$optimizer)
    corrEst.args <- corrEstBlob$corrEst.args ## but corrEstBlob also has $corrEst.form which will stay there for later use
  }
  if (need_simple_lambda <- need_ranefPars_estim <- models[[1]]=="etaHGLM") {
    need_simple_lambda <- any(is.na(lambda.Fix) & ! ranCoefs_blob$is_set)
    need_ranefPars_estim <-  (need_simple_lambda || ! is.null(corr_est))
  } 
  #
  whichadj <- which(attr(ZAlist,"exp_ranef_types")=="adjacency") ## bug presumably corrected here 30/12/2107
  test_inner_estim_rho <- (length(whichadj) && ! is.null(adjd <- attr(LMatrices[[whichadj]],"symsvd")$adjd))
  phi.Fix <- processed$phi.Fix
  if (is.null(phi.Fix)) phi.Fix <- .getPar(ranFix,"phi") ## if set in final call of outer estimation 
  
  nothing_to_fit <-  ((! need_ranefPars_estim) && pforpv==0L && (! is.null(phi.Fix)) 
                      && (models[[1]]=="etaHGLM" && (! is.null(etaFix$v_h))) )
  
  ### case where nothing to fit #############################################
  if ( nothing_to_fit ) { 
    if (test_inner_estim_rho) {  
      u.range <- (cum_n_u_h[whichadj]+1L):cum_n_u_h[whichadj+1L]
      adj_rho <- corr_est$rho
      if (is.null(adj_rho)) adj_rho <- .getPar(ranFix,"rho") ## could this occur with test_inner_estim_rho ?
      if (is.null(adj_rho)) adj_rho <- init.HLfit$rho
      if ( ! is.null(adj_rho)) fixed_adjacency_info <- list(whichadj=whichadj, u.range=u.range, coeffs=1/(1-adj_rho*adjd))
    } else fixed_adjacency_info <- NULL
    return(.nothing_to_fit(phi.Fix, off, models, etaFix, rand.families, cum_n_u_h, lcrandfamfam, 
                           lambda.Fix, vec_n_u_h, n_u_h, fixed_adjacency_info, ZAL, BinomialDen, processed)) 
  }   ### RETURN !! ## FR->FR but p_bv is not returned. (fixme?: not of class HLfit)
  
  ##########################################################################################
  ##########################################################################################
  ##########################################################################################

  ### Initial values  for lambda, phi and beta from lambda.Fix, phi.Fix, or init.HLfit ##### 
  ## Initial estimate for beta  (etaFix acts directly in auglinmodfit)
  beta_eta <- processed$port_env$port_fit_values$fixef
  if (is.null(beta_eta)) {
    beta_eta <- numeric(pforpv)
    if (pforpv) {
      beta_eta <- init.HLfit$fixef
      if ( ! is.null(beta_eta) && ! is.null(attr(processed$AUGI0_ZX$X.pv,"scaled:scale"))) {
        beta_eta <- .scale(beta=beta_eta,X=processed$AUGI0_ZX$X.pv)
      }
    }
  }
  ## Initial estimate for phi 
  phi_est <- phi.Fix
  if (is.null(phi_est)) phi_est <- processed$port_env$port_fit_values$phi_est
  if (is.null(phi_est)) phi_est <- init.HLfit$phi ## must be 'response' value(s)
  if (models[[1]]=="etaHGLM") { 
    ## Initial estimate for u_h, v_h 
    gaussian_u_ranges <- processed$gaussian_u_ranges 
    psi_M <- rep(attr(rand.families,"unique.psi_M"),diff(cum_n_u_h))
    v_h <- .initialize_v_h(psi_M=psi_M, etaFix=etaFix, 
                          init.HLfit=init.HLfit, ## checks init.HLfit$v_h
                          cum_n_u_h=cum_n_u_h, rand.families=rand.families, port_env=processed$port_env)
    u_h <- .u_h_v_h_from_v_h(v_h, rand.families=rand.families, cum_n_u_h=cum_n_u_h,
                            lcrandfamfam=lcrandfamfam, lower.v_h=NULL, upper.v_h=NULL)
    ## Initial estimate for lambda in 'compact" form
    init.lambda <- .calc_initial_init_lambda(lambda.Fix, nrand, processed, ranCoefs_blob, init.HLfit)
  } else init.lambda <- NULL
  ###
  ######### missing Initial estimates for mu, phi, lambda by GLM ####################
  if (  is.null(beta_eta) || is.null(phi_est) || anyNA(init.lambda) ) { 
    inits_by_glm <- .get_inits_by_glm(processed, family=family, # using possibly postprocessed family
                                      reset=(family$family %in% c("COMPoisson","negbin"))) 
    ## : uses processed$y, $BinomialDen, [["control.glm"]]
  }
  ## Finalize initial values for beta_eta
  if (is.null(beta_eta) ) beta_eta <- inits_by_glm$beta_eta
  intervalInfo <- processed$intervalInfo
  if (!is.null(intervalInfo)) {
    parmcol <- attr(intervalInfo$parm,"col")
    beta_eta[parmcol] <- intervalInfo$init ## already appropriately scaled if X.pv has been scaled
  }  
  ## Finalize initial values for phi 
  if (is.null(phi_est) ) {
    ## there are many cases that .get_init_phi does not handle
    if ( models[["phi"]] == "phiScal") {
      if (is.call(processed$prior.weights)) {
        phi_est <- .get_init_phi(processed,weights=NULL)
      } else phi_est <- .get_init_phi(processed,weights=processed$prior.weights)
    }
    if ( is.null(phi_est) ) phi_est <- inits_by_glm$phi_est
    # at this point fitme call -> calc_init_dispPars() has set phi >= 1e-4
    # This may be lower in HLfit call (included for bootstrap) (different from lambda)
    if (models[["phi"]] != "phiScal") {
      phi_est <- rep(phi_est,nobs) ## moche ## FR->FR why is this necess ?
    }
  }
  ## Finalize initial values for lambda
  if (models[[1]]=="etaHGLM") {
    lambda_est <- .HLfit_finalize_init_lambda(models, init.lambda, processed, ZAL, cum_n_u_h, vec_n_u_h, n_u_h, ranCoefs_blob)
  }
  ###
  ## predictor from initial values
  if (models[[1]]=="etaHGLM") { ## linear predictor for mean with ranef
    eta <- off + drop(processed$AUGI0_ZX$X.pv %*% beta_eta) + drop(ZAL %id*% v_h)
  } else  eta <- off +drop(processed$AUGI0_ZX$X.pv %*% beta_eta) ## no iteration hence no updating  ## FREQS
  ## conversion to mean of response variable (COUNTS for binomial)
  muetablob <- .muetafn(eta=eta,BinomialDen=BinomialDen,processed=processed) 
  mu <- muetablob$mu ## if Bin/Pois, O(n): facteur BinomialDen dans la transfo mu -> eta ## nonstandard mu des COUNTS
  w.resid <- .calc_w_resid(muetablob$GLMweights,phi_est) ## 'weinu', must be O(n) in all cases
  conv.phi <- conv.lambda <- conv.corr <- FALSE
  if (models[[1]]=="etaHGLM") {
    if (! is.null(intervalInfo)) {
      intervalInfo$parmcol_ZX <- n_u_h+parmcol 
      intervalInfo$parmcol_X <- parmcol 
      intervalInfo$ranFix <- ranFix
      if (processed$HL[1]==0L) { intervalInfo$likfn <- "hlik" } else {intervalInfo$likfn <- "p_v"} ##  use h in PQL/L (> v1.5.59) 
    }
    wranefblob <- .updateW_ranefS(cum_n_u_h,rand.families,lambda_est,u_h,v_h) ## initilization !
    if (pforpv==0L && !is.null(etaFix$v_h)) {
      maxit.mean <- 0 ## used in test near the end...
    } else if ( LMMbool && is.null(intervalInfo) ) {
      maxit.mean <- 1 ## 1 is sufficient for LMM as Hessian does not vary with beta_eta  => quadratic function;
      # ./ E X C E P T for calculation of confidence intervals: at least two intervalSteps are required. Quite visible when 
      # dispersion params areouter-estimated (fitme) in which case there isno outer iteration to compensate a small maxit.mean  
    } else { ## even h maximization in *G*LMMs 
      if ( ! is.null(phi.Fix) && ! need_simple_lambda) { ## allFix hence no true outer iteration 
        maxit.mean <- iter.mean.dispFix 
      } else maxit.mean <- iter.mean.dispVar # If phi.Fix and lambda.Fix, the only way to have 'outer' convergence is to have 'inner' convergence
    } 
  } else if (models[[1]]=="etaGLM") {
    if (! is.null(intervalInfo)) {
      intervalInfo$parmcol_X <- parmcol 
    }
    ## FR->FR on doit pouvoir mettre maxit.mean = 0 dans pas mal de cas ?
    ## attention toutefois à COMPoisson negbin...
    if ( ! is.null(phi.Fix)) { ## 
      maxit.mean <- iter.mean.dispFix 
    } else maxit.mean <- iter.mean.dispVar # If phi.Fix and lambda.Fix, the only way to have 'outer' convergence is to have 'inner' convergence
  }
  prev_lik <- -Inf
  conv_logL <- NA
  dvdlogphiMat <- NULL
  dvdloglamMat <- NULL
  penul_lambda <- NULL
  residProcessed <- processed$residProcessed ## currently NULL except for phiHGLM
  ########################################
  ######### Main loop ####################
  ########################################
  iter <- 0L
  prevmsglength <- 0L
  if (HL[1]=="SEM") { ## specif probit
    processed$SEMargs$qr_X <- qr(processed$AUGI0_ZX$X.pv) 
    locarglist <- list(processed=processed, ZAL=ZAL, beta_eta=beta_eta,
                       off=off, corr_est=corr_est, init.lambda=attr(lambda_est,"init.lambda"),
                       lambda.Fix=lambda.Fix, LMatrices=LMatrices, verbose=verbose)
    SEMblob <- .probitgemWrap("SEMwrap",arglist=locarglist, pack="probitgem") # eval(as.call(c(quote(SEMwrap),logarglist)))
    beta_eta <- SEMblob$beta_eta
    corr_est["rho"] <- SEMblob$corr_est["rho"] ## may again be NULL
    if (is.null(SEMblob$glm_lambda)) {
      lambda_est <- lambda.Fix
    } else lambda_est <- predict(SEMblob$glm_lambda,type="response")
    u_h <- v_h <- SEMblob$v_h
    logLapp <- SEMblob$logLapp
    attr(logLapp,"seInt") <- SEMblob$seInt ## may be NULL
    ## for summary.HLfit -> beta_cov (_info ?)
    eta <- off + drop(processed$AUGI0_ZX$X.pv %*% beta_eta) + drop(ZAL %id*% v_h)
    muetablob <- .muetafn(eta=eta,BinomialDen=BinomialDen,processed=processed) 
    w.resid <- .calc_w_resid(muetablob$GLMweights,phi_est) ## 'weinu', must be O(n) in all cases
    wranefblob <- .updateW_ranefS(cum_n_u_h,rand.families,lambda_est,u_h,v_h) ## no fit, likelihood computation
    sqrt.ww <- sqrt(c(w.resid,wranefblob$w.ranef))
    ##
  } else while ( TRUE ) { ##the main loop with steps: new linear predictor, new leverages, new phi, new w.resid, new lambda, new fn(lambda)
    if (models[[1]]=="etaHGLM") {
      if (! is.null(intervalInfo)) {
        intervalInfo$corr_est <- corr_est ## currently needs to be added ex tempo... apparently only for warn_intervalStep()
        intervalInfo$beta_eta <- beta_eta ## ex tempo: the current estimate of the CI bound
      } ## else intervalInfo remains NULL
      # if (models[["phi"]]=="phiScal") {
      #   H_global_scale <- phi_est[1L]
      # } else H_global_scale <- exp(mean(log(phi_est)))
      H_global_scale <- .calc_H_global_scale(w.resid)
      if ( processed$sparsePrecisionBOOL ) { 
        adj_rho <- corr_est$rho
        if (is.null(adj_rho)) adj_rho <- .getPar(ranFix,"rho") ## could this occur with test_inner_estim_rho ?
        if (is.null(adj_rho)) adj_rho <- init.HLfit$rho
        
        
        # For ML binary and LevM, first PQL binary then ML. 
        # The basic fit (run for all other models) is the second.
        if (prePQL <-(processed$HL[1L]==1L && .determine_LevenbergM(processed$LevenbergM,which="user_prefit"))
            # && is.null(processed$port_env$port_fit_values)
            ) { 
          ## first PQL LevenbergM then ML 
          processed$HL[1L] <- 0L
          processed$p_v_obj <- "hlik"
          pqlblob <- .solve_IRLS_as_spprec(ZAL=ZAL, y=y, n_u_h=cum_n_u_h[nrand+1L],
                                             H_global_scale=H_global_scale, # de facto ignored through trivial tests
                                             lambda_est=lambda_est, # homoscedastic for CAR! confusing!
                                             muetablob=muetablob,
                                             off=off, maxit.mean=maxit.mean, etaFix=etaFix,
                                             ## for ! LMM
                                             eta=eta,
                                             ## supplement for LevenbergM
                                             beta_eta=beta_eta,
                                             ## supplement for ! GLMM
                                           wranefblob=wranefblob, u_h=u_h, v_h=v_h, w.resid=w.resid, phi_est=phi_est,
                                             for_init_z_args=list(nrand=nrand, psi_M=psi_M, ranFix=ranFix),
                                             for_intervals=intervalInfo,
                                             ##
                                             trace=verbose["TRACE"],
                                             processed=processed,corrPars=list(rho=adj_rho))
          muetablob <- pqlblob$muetablob
          eta <- pqlblob$eta
          beta_eta <- pqlblob$beta_eta
          wranefblob <- pqlblob$wranefblob
          u_h <- pqlblob$u_h
          v_h <- pqlblob$v_h
          w.resid <- .calc_w_resid(muetablob$GLMweights,phi_est) # pqlblob$w.resid
          processed$HL[1L] <- 1L
          processed$p_v_obj <- "p_v"
          #pql_levm_p_v <- .calc_APHLs_from_auglinmodblob(pqlblob,processed, which="p_v", phi_est, lambda_est)
          pql_levm_p_v <- .calc_APHLs_from_ZX(auglinmodblob=pqlblob,processed=processed, which="p_v")
        }
        auglinmodblob <- .solve_IRLS_as_spprec(ZAL=ZAL, y=y, n_u_h=cum_n_u_h[nrand+1L],
                                                 H_global_scale=H_global_scale, # de facto ignored through trivial tests
                                                 lambda_est=lambda_est, # homoscedastic for CAR! confusing!
                                                 muetablob=muetablob,
                                                 off=off, maxit.mean=maxit.mean, etaFix=etaFix,
                                                 ## for ! LMM
                                                 eta=eta,
                                                 ## supplement for LevenbergM
                                                 beta_eta=beta_eta,
                                                 ## supplement for ! GLMM
                                               wranefblob=wranefblob, u_h=u_h, v_h=v_h, w.resid=w.resid, phi_est=phi_est,
                                                 for_init_z_args=list(nrand=nrand, psi_M=psi_M, ranFix=ranFix), 
                                                 for_intervals=intervalInfo,
                                                 ##
                                                 trace=verbose["TRACE"],
                                                 processed=processed,corrPars=list(rho=adj_rho))
        ## FIXME provide the gradient by the auglinmodblob and check it and then suggest LevM if not already used
      } else {
        # For ML binary and LevM, first PQL binary then ML. 
        # The basic fit (run for all other models) is the second 
        if (prePQL <-(processed$HL[1L]==1L && .determine_LevenbergM(processed$LevenbergM,which="user_prefit"))
            # && is.null(processed$port_env$port_fit_values) ## FIXME reconsider: effect on #605 of BINARYboot 
        ) { 
          ## first PQL LevenbergM then ML 
          processed$HL[1L] <- 0L
          processed$p_v_obj <- "hlik"
          pqlblob <- .solve_IRLS_as_ZX(processed$AUGI0_ZX$X.pv, ZAL, y, n_u_h=cum_n_u_h[nrand+1L], 
                                H_global_scale=H_global_scale, 
                                lambda_est=lambda_est, muetablob=muetablob,
                                off=off, maxit.mean=maxit.mean, etaFix=etaFix,
                                ## for ! LMM
                                eta=eta, 
                                ## supplement for LevenbergM
                                beta_eta=beta_eta,
                                ## supplement for ! GLMM
                                wranefblob=wranefblob, u_h=u_h, v_h=v_h, w.resid=w.resid, phi_est=phi_est,
                                for_init_z_args=list(nrand=nrand, psi_M=psi_M, ranFix=ranFix), 
                                for_intervals=intervalInfo,
                                ##
                                trace=verbose["TRACE"],
                                processed=processed)
          muetablob <- pqlblob$muetablob
          eta <- pqlblob$eta
          beta_eta <- pqlblob$beta_eta
          wranefblob <- pqlblob$wranefblob
          u_h <- pqlblob$u_h
          v_h <- pqlblob$v_h
          w.resid <- .calc_w_resid(muetablob$GLMweights,phi_est) # pqlblob$w.resid
          H_global_scale <- .calc_H_global_scale(w.resid)
          processed$HL[1L] <- 1L
          processed$p_v_obj <- "p_v"
          #pql_levm_p_v <- .calc_APHLs_from_auglinmodblob(pqlblob,processed, which="p_v", phi_est, lambda_est)
          pql_levm_p_v <- .calc_APHLs_from_ZX(auglinmodblob=pqlblob,processed=processed, which="p_v")
        }
        auglinmodblob <-  .solve_IRLS_as_ZX(processed$AUGI0_ZX$X.pv, ZAL, y, n_u_h=cum_n_u_h[nrand+1L], 
                           H_global_scale=H_global_scale, 
                           lambda_est=lambda_est, muetablob=muetablob,
                           off=off, maxit.mean=maxit.mean, etaFix=etaFix,
                           ## for ! LMM
                           eta=eta, 
                           ## supplement for LevenbergM
                           beta_eta=beta_eta,
                           ## supplement for ! GLMM
                           wranefblob=wranefblob, u_h=u_h, v_h=v_h, w.resid=w.resid, phi_est=phi_est,
                           for_init_z_args=list(nrand=nrand, psi_M=psi_M, ranFix=ranFix), 
                           for_intervals=intervalInfo,
                           ##
                           trace=verbose["TRACE"],
                           processed=processed)
      }
      #if ( ! .determine_LevenbergM(processed$LevenbergM) && maxit.mean>1L && auglinmodblob$innerj==maxit.mean) {
      #  processed$LevenbergM <- c(LevenbergM=TRUE,PQL_prefit=TRUE) ## FIXME crude rescue: the IRLS procedure shouls autocorrect ?
      #}
      ##############################
      beta_eta <- auglinmodblob$beta_eta
      wranefblob <- auglinmodblob$wranefblob # updated only if !LMM
      muetablob <- auglinmodblob$muetablob # updated only if !LMM
      mu <- muetablob$mu ## testé par accident, necess dans test COMPoisson HLfit...
      w.resid <- auglinmodblob$w.resid # updated only if !LMM
      v_h <- auglinmodblob$v_h
      u_h <- auglinmodblob$u_h
      eta <- auglinmodblob$eta
      innerj <- auglinmodblob$innerj
    } else if (models[[1]]=="etaGLM") {
      if (pforpv>0L  && maxit.mean) {
        ## resultat nomme' auglinmodblob pour avancer vers simplif du code, mais je ne peux suppser qu'auglinmodblob est toujours calculé
        auglinmodblob <- .calc_etaGLMblob(processed=processed,  mu=mu, eta=eta, muetablob=muetablob, beta_eta=beta_eta, 
                                      w.resid=w.resid, phi_est=phi_est, off=off, maxit.mean=maxit.mean, 
                                      verbose=verbose, for_intervals=intervalInfo, Xtol_rel=spaMM_tol$Xtol_rel)
        eta <- auglinmodblob$eta 
        muetablob <- auglinmodblob$muetablob 
        mu <- muetablob$mu
        beta_eta <- auglinmodblob$beta_eta 
        w.resid <- auglinmodblob$w.resid
        innerj <- auglinmodblob$innerj
      } else auglinmodblob <- NULL 
    } # end etaGLM...
    if(inherits(mu,"Matrix")) mu <- drop(mu) ## pb calcul deviance_residual 
    ########## LEVERAGES
    #### base from hat matrix
    if (models[[1]]=="etaHGLM") {
      if (need_ranefPars_estim || is.null(phi.Fix)) {
        if (maxit.mean==0L) {
          stop("(!) Computation of leverages with maxit.mean=0: check that this is meaningful.")
        } # ELSE rWW was updated in the inner loop for betaV
        hatval <- .get_hatvalues_MM(auglinmodblob$sXaug,X.Re=X.Re, auglinmodblob$weight_X)
        lev_lambda <- hatval[seq(n_u_h)]  ## for the ranef residuals (lambda)
        lev_phi <- hatval[(n_u_h+1L):(n_u_h+nobs)] ## for the error residuals (phi)
        hatval <- c(lev_phi,lev_lambda) ## old order; patch for further hatval corr 
      }
    } else if (is.null(phi.Fix)) { ## phi estim in GLM fitted by ML. 
      lev_phi <- .get_hatvalues_FM(X.Re, augX=processed$AUGI0_ZX$X.pv, w.resid)
    }
    ## (HL[2]=0, HL[3]=0): previous hat matrix -> p 
    ## (HL[2]=0, HL[3]=1): notEQL -> tilde(p), (HL[2]=1 && ): full correction -> q 
    ## (HL[2]=1, HL[3]=1): full correction -> q 
    #### contribution from GLM weights
    if (HL[2L]>0L && models[[1L]]=="etaHGLM" 
        && (need_simple_lambda || is.null(phi.Fix)) ) { ## LeeN01 HL(.,1) ie the + in 'EQL+'
      ## first the d log hessian / d log lambda or phi corrections
      ### For the d log hessian first the derivatives of GLM weights wrt eta 
      ##################### noter que c'est le coef2 de HL(1,.), but mu,eta may have been updated since coef2 was computed
      dlW_deta <- .calc_dlW_deta(dmudeta=drop(muetablob$dmudeta),family=family,mu=drop(mu),eta=drop(eta),
                                BinomialDen=BinomialDen,canonicalLink=processed$canonicalLink,
                                w.resid=w.resid)$dlW_deta
      ### we join this with the deriv of log w.ranef wrt v_h
      dlW_deta_or_v <- c(dlW_deta, wranefblob$dlogWran_dv_h )  ## vector with n+'r' elements
      # dlogWran_dv_h is 0 gaussian ranef; d2mudeta2 is 0 for identity link => vector is 0 for LMM
      ## else we continue the computation of the d log hessian term d2 log dens u/ dv dloglambda
      ## where we ignore the contribution of the log Jacobian, log(dth/du), to log dens u since it is not fn of lambda
      ## hence this is d2 log dens th(u)/ dv dloglambda
      if (any(dlW_deta_or_v!=0L)) {
        lev_phi_range <- 1L:nobs
        leve__dlW_deta_or_v <- hatval * dlW_deta_or_v
        leve__dlW_deta_or_v__ZALI <-  leve__dlW_deta_or_v[lev_phi_range] %*% ZAL +  leve__dlW_deta_or_v[-(lev_phi_range)]
        
        if (need_simple_lambda) {
          dvdloglamMat <-  .calc_dvdloglamMat_new(dlogfthdth=(psi_M - u_h)/lambda_est, ## the d log density of th(u)
                                                 cum_n_u_h=cum_n_u_h,lcrandfamfam=lcrandfamfam,rand.families=rand.families,
                                                 u_h=u_h,
                                                 sXaug=auglinmodblob$sXaug, # not d2hdv2_info
                                                 stop.on.error=stop.on.error)
          dleve <- as.vector(leve__dlW_deta_or_v__ZALI %*% dvdloglamMat) # (r+n).(r+n)Xr.rXr = r (each element is a sum over r+n terms= a trace)
          lev_lambda <- lev_lambda - dleve  
        } 
        ## 
        if (is.null(phi.Fix)) {
          dh0deta <- ( w.resid *(y-mu)/muetablob$dmudeta ) ## 12/2013 supp BinomialDen (soit Bin -> phi fixe=1, soit BinomialDen=1)
          dvdlogphiMat <- .calc_dvdlogphiMat_new(dh0deta=dh0deta,ZAL=ZAL, 
                                                 sXaug=auglinmodblob$sXaug,  # not d2hdv2_info
                                                 stop.on.error=stop.on.error)
          dleve <- as.vector(leve__dlW_deta_or_v__ZALI %*% dvdlogphiMat) # (r+n) . (r+n)Xr . rXn = n (each element is a sum over r+n terms= a trace)
          lev_phi <- lev_phi - dleve  
        } 
      }
    }
    if (HL[2L]>1) {stop("Need a_i correction in Table 7 of NohL07 ie derivatives of second order correction wrt dips param.")}
    #### contribution from exact likelihood function instead of EQL
    if (HL[3L]!=0 ) {## HL(.,.,1) ie , p_bv(h), not EQL p_bv(q+), LeeNP p89; distinction does not arise for PQL <=> Gaussian ranefs...  
      # lambda
      if (models[[1L]]=="etaHGLM" && need_simple_lambda) ## d h/ d !log! lambda correction     
        lev_lambda <- lev_lambda + .corr_notEQL_lambda(nrand,cum_n_u_h,lambda_est,lcrandfamfam) 
      # phi hence not poiss,binom:
      if (family$family=="Gamma" && is.null(phi.Fix) ) { ## d h/ d !log! phi correction (0 for gauss. resid. error). Not tied to REML
        phiscaled <- phi_est/eval(prior.weights) ## 08/2014 ## bug "*" corrected -> "/" 2015/03/05
        lev_phi <- lev_phi +  1+2*(log(phiscaled)+digamma(1/phiscaled))/phiscaled ## LNP p. 89 and as in HGLMMM IWLS_Gamma
      }    
    }
    ######### Dispersion Estimates for phi #####################
    if (is.null(phi.Fix)) { ## if phi is estimated (phi.Fix set to 1 for Poisson, Binomial)
      ## leverages have been computed before the  inner loop, which did not change the design matrices 
      lev_phi[lev_phi>1-1e-8] <- 1-1e-8
      ## updated residuals from updated mu must be used (LeeNP p.161) 
      ## Once in Gamma GLM, y=25.75563, y-mu=-5.996906e-08, yielded negative dev.resid
      if (models[["phi"]]=="phiHGLM") {
        # This cannot be efficiently outer-optimized (when we outer-optimze phi we provide the response of the "phi-model", 
        # not the parameters of the phi-model. Here we cannot provide the phi values, we need to evuate them, using leverages).
        residProcessed$prior.weights <- structure((1-lev_phi)/2,unique=FALSE) # expected structure in processed.
        # uses of prior weights matches thatin input of calcPHI -> dispGammaGLM 
        residProcessed$data$.phi <- family$dev.resids(y,mu,wt= eval(prior.weights))/(1-lev_phi) 
        residProcessed$y <- residProcessed$data$.phi
        residProcessed$HLframes$Y <- as.matrix(residProcessed$data$.phi)
        #  residProcessed$port_fit_values allows a previous 'close' [as defined by condition on logLik change] outer fit 
        #   to be used to initialize the 1st inner fitme of the new HLfit.
        #  residProcessed$fixed, until modified below, contains preprocessed resid.model's fixed lambda, and phi.
        #   and info in residModel$fixed must match (duplicate!) that in residProcessed:
        #   <processed=residProcessed>$lambda.Fix contains globally fixed lambda for the resid-fit.
        #  Finally, residProcessed$envir$ranPars may be used for outer-optimization at the mean-fit level 
        #   ('outer_optim_resid' option) of the resid-fit parameters,
        #   in which case residProcessed$envir$ranPars contains the objective's arguments that are resid-fit parameters,
        #   which have been written in (by [HLCor|HLfit].obj()).
        #   and should now be copied in phifitarglist$fixed:
        phifitarglist <- processed$residModel 
        ## $residModel: including formula, control.dist, family, fixed, rand.family... but most of the info used is in residProcessed!
        # it is tempting to select the arguments in formals(fitme_body) but this includes '...'
        phifitarglist["init.HLfit"] <- NULL ## for clarity
        phifitarglist["formula"] <- NULL ## for clarity
        phifitarglist["resid.model"] <- NULL ## for clarity; processed must have all relevant info
        phifitarglist["family"] <- NULL ## for clarity
        phifitarglist["rand.family"] <- NULL ## for clarity
        phifitarglist$fixed <- structure(.modify_list(phifitarglist$fixed, residProcessed$envir$ranPars ),
                                         type=.modify_list(attr(phifitarglist$fixed,"type"), attr(residProcessed$envir$ranPars,"type") ))
        phifit_init <- as.list(phifitarglist[["init"]]) ## NULL-> list(); same on next line
        resid_lambda_object <- NULL 
        ##### (1) get info to add to phifit_init
        if (iter==0L) { 
          if (is.null(processed$residModel$fixed[["phi"]])) { ## ie if user set fixed$phi=NA, processed in .reformat_resid_model()
            phifit_init$phi <- 1 ## A case can be made for fixing it to 1; see working doc, end of 'Gamma GLM formulation of REML estimators'
          } # and  keeps other init values as given by user.
          if ( ! is.null(processed$port_env$objective) && verbose["phifit"]) cat("\n")
          #
          # It is not sure that the following line is useful if residProcessed$port_fit_values are available, 
          #  but otherwise it makes sense:
          residProcessed$envir$inits_by_glm <- NULL ## recompute them if needed; do not use glm results on a priori distinct response
          #
          # The condition for using residProcessed$.$port_fit_values should be 
          # that the parent's processed$.$port_fit_values are available, suggesting convergence of the joint DHGLM:
          if ( ! is.null(processed$port_env$port_fit_values)) { 
            phifit_init_HLfit <- as.list(residProcessed$port_env$port_fit_value[["init_HLfit"]])
            # phifit_init$lambda default value may be NULL which means that phifit's fitme is likely to use outer optimisation
            # but it might also contain NA's. This is controlled by residModel's non-defaults
            resid_lambda_object <- residProcessed$port_env$port_fit_values$lambda_object
            resid_corrPars <- residProcessed$port_env$port_fit_values$corrPars
          } else {
            residProcessed$port_env$port_fit_values <- NULL ## overrides the decision that HLfit made 'locally' within the phifit
            phifit_init_HLfit <- list()
            resid_lambda_object <- resid_corrPars <- NULL
          }
        } else { ## iter>0
          #phifit_init_HLfit created at iteration 0
          if (is.null(processed$residModel$fixed$fixef)) phifit_init_HLfit$fixef <- fixef(phifit) ## : Use an init if the parameters are not fixed. 
          phifit_init_HLfit$v_h <- phifit$v_h
          # FIXME one could *update* a corrPars[[.]]$rho element in init_HLfit... not done currently... instead
          # use ranef parameters from previous 'iter' to initiate new optimization (corrPars likely to be very slightly shifted) 
          phifit_init$corrPars <- .new_phifit_init_corrPars(phifit, innershift=1e-7)
          resid_lambda_object <- phifit$lambda.object
          if (is.null(processed$residModel$fixed$phi)) phifit_init$phi <- phifit$phi 
        } ## end if iter==0L else ...
        ###### (2) ADD elements to phifit_init and phifit_init_HLfit
        phifit_init <- .post_process_resid_corrPars(phifit_init, resid_corrPars)
        if ( ! is.null(resid_lambda_object)) {
          resid_lambda <- resid_lambda_object$lambda
          names(resid_lambda) <- paste(seq(length(resid_lambda))) ## no names already ? Indeed no. (09/2018)
          phifit_init[["lambda"]] <- unlist(resid_lambda[which(resid_lambda_object$type=="outer")])
          phifit_init_HLfit[["lambda"]] <- unlist(resid_lambda[which(resid_lambda_object$type=="inner")]) # attr(.,"type") derives from lambda.object$type which includes "inner" 
        }
        # ###### (3) copy everything in phifitarglist
        phifitarglist[["init"]] <- phifit_init
        residProcessed[["init_HLfit"]] <- phifit_init_HLfit ## global change sicne residProcessed is an environment in $processed : .../...
        phifitarglist$processed <- residProcessed   ## that means that the $processed of the next HLfit call contains the phifit_init_HLfit of the last iter
        # It's the parent 'processed' which bears the TRACE info (cf comment in residProcessed <- .preprocess(.) arguments)
        if (processed$verbose["TRACE"]) {cat(paste("\nBegin tracing residual dispersion fit for iter=",iter,":\n"))}
        phifit <- do.call("fitme_body",phifitarglist)
        #if ( ! is.null(processed$port_env$port_fit_values)) undebug(glm.fit)
        if (processed$verbose["TRACE"]) {cat(paste("... end tracing residual dispersion fit for iter=",iter,"."))}
        la <- phifit$lambda
        names(la) <- paste0(seq_len(length(la)),".lam")
        cpla <- c(unlist(get_ranPars(phifit,which="corrPars")),la)
        if (verbose["phifit"]) {
          prevmsglength <- overcat(
            paste0(processed$port_env$prefix,
                   "phi fit's iter=",iter+1L,
                   ", .phi[1]=",signif(phifit$y[1],5),", ",
                   paste0(names(cpla),"=", signif(cpla,6), collapse=", "),
                   ";           "),
            prevmsglength)
        }
        next_phi_est <- phifit$fv
      } else {
        # to obtain the phi estimate given by summary.glm(), one must use
        #  dev.res <- wt * ((y-mu)/family$mu.eta(eta))^2 ## wt * EQL residuals
        # but the logLik differs from that given by logLik.glm(). See Details in ?HLfit
        calcPHIblob <- .calcPHI(oriFormula=processed$residModel$formula,
                               dev.res= family$dev.resids(y,mu,wt= eval(prior.weights)),
                               #: times pw to be an estimate of same phi accross level of response
                               # but not same phi as when there is no pw !
                               # double pw => double phi_est so that phi_est_i :=phi_est/pw_i is unchanged
                               data=data,
                               family=processed$residModel$family,
                               lev_phi=lev_phi,
                               control=processed[["control.glm"]],
                               phimodel=models[["phi"]],
                               verbose=verbose,
                               control.phi=control.HLfit$`control.phi`)
        if (! is.null(locw <- calcPHIblob$glm_phi$warnmess)) warningList$innerPhiGLM <- locw
        next_phi_est <- calcPHIblob$next_phi_est # value of *phi* (not phi_i:= phi/prior.weights as pw are usd inGLMweights, not here)  
      }
      if (any(next_phi_est<1e-12)) {
        if (is.null(min_phi <- control.HLfit$min_phi)) {
            .hack_options_error(message=paste0("Low (<1e-12) fitted residual variance (phi):\n",
                                               "this may be a genuine result for data without appropriate replicates\n",
                                               "                             and a model that allows overfitting, but\n",
                                               "(1) this may also point to problems in the data (duplicated response values?);\n",
                                               "(2) this may have led to the present error from a later computation.\n",
                                               "You may overcome this by setting control.HLfit$min_phi\n",
                                               "    to 1e-10 or some other low, but not too low, value.\n",
                                               "Still, the computed likelihood maximum wrt all parameters may be inaccurate.\n"))
            # crash later computations: ::Cholesky(wd2hdv2w) problem
        } else next_phi_est[next_phi_est<min_phi] <- min_phi  
      } else .hack_options_error(message=NULL)
      if (all(abs(next_phi_est-phi_est) < spaMM_tol$Xtol_rel* phi_est+ processed$spaMM_tol$Xtol_abs)) { 
        conv.phi <- TRUE ## 'weak convergence'... 
      } else conv.phi <- FALSE
      
    } else {conv.phi <- TRUE} ## there is a phi.Fix, already -> phi_est
    ###############################################################
    ######### Dispersion Estimates for lambda #####################
    ###############################################################
    
    if (need_ranefPars_estim) { ## lambda must be estimated 
      levlam_bound <- 1 - .spaMM.data$options$regul_lev_lambda
      if (any(abs(lev_lambda) > levlam_bound)) { ## abs... not commented when written...
        lev_lambda[lev_lambda>levlam_bound] <- levlam_bound
        warningList$leveLam1 <- TRUE
      }      
      ################## ranefEstargs mustcontain arguments for makeCoveEst1 => its names are constrained
      ranefEstargs <- list(u_h=u_h,ZAlist=processed$ZAlist,cum_n_u_h=cum_n_u_h,
                           prev_LMatrices=LMatrices,
                           #lcrandfamfam=lcrandfamfam,
                           processed=processed,
                           w.resid=w.resid)
      if (any(ranCoefs_blob$isRandomSlope)) { ## if random-slope model
        covEstmethod <- .spaMM.data$options$covEstmethod ## note same call in calcRanefPars
        if (is.null(covEstmethod)) stop("spaMM.getOption('covEstmethod') should not be NULL")
        if (covEstmethod == ".makeCovEst1") {
          ranefEstargs <- c(ranefEstargs,list(phi_est=phi_est,
                                              as_matrix=( ! inherits(ZAL,"Matrix")),v_h=v_h))
          H_global_scale <- .calc_H_global_scale(w.resid)
          ## MakeCovEst defines à local ZAL and the eta,mu, w.resid must generally be recomputed locally for this ZAL
          ranefEstargs$MakeCovEst_pars_not_ZAL_or_lambda <- list(X.pv=processed$AUGI0_ZX$X.pv, y=y, n_u_h=cum_n_u_h[nrand+1L], 
                                                                 H_global_scale=H_global_scale, 
                                                                 muetablob=NULL,
                                                                 off=off, maxit.mean=maxit.mean, etaFix=etaFix,
                                                                 ## for ! LMM
                                                                 eta=NULL, 
                                                                 ## supplement for LevenbergM
                                                                 beta_eta=beta_eta,
                                                                 ## supplement for ! GLMM
                                                                 u_h=u_h, v_h=v_h, w.resid=NULL, phi_est=phi_est,
                                                                 for_init_z_args=list(nrand=nrand, psi_M=psi_M, ranFix=ranFix), 
                                                                 for_intervals=intervalInfo,
                                                                 ##
                                                                 processed=processed)
        } else stop("some code for alternative covEstmethod would be needed here.")
      }
      calcRanefPars_blob <- .calcRanefPars(HLfit_corrPars=HLfit_corrPars,
                                          lev_lambda=lev_lambda,
                                          ranefEstargs=ranefEstargs,
                                          ranCoefs_blob=ranCoefs_blob,
                                          lambda.Fix=lambda.Fix,
                                          rand.families=rand.families,
                                          psi_M=psi_M,
                                          verbose=verbose,
                                          iter=iter,
                                          control=processed[["control.glm"]]
      )
      HLfit_corrPars <- calcRanefPars_blob$HLfit_corrPars
      next_randcoeff_cov_est <- calcRanefPars_blob$HLfit_corrPars$random_coeff ## vector
      next_lambda_est <- calcRanefPars_blob$next_lambda_est  ## T H I S is what affects next beta,v estimates when rho is inner estimated in CAR.
      ########################################
      # => variation of log(u^2/lamdba) = simplified likRanU convergence  (from 1.9.31)
      next_u_vs_lambda <- 2*log(abs(u_h[gaussian_u_ranges])+1e-12)-log(next_lambda_est[gaussian_u_ranges])    
      conv_lambda_vs_u <- (iter> 1L && 
                             all( abs(next_u_vs_lambda-prev_u_vs_lambda) < 500*spaMM_tol$Xtol_rel) )        
      prev_u_vs_lambda <- next_u_vs_lambda
      ## Absolu ou relatif selon valeur de lambda:
      if ( is.null(phi.Fix) && max(phi_est)<1e-4) { ## default $Xtol_abs a bit lax for maximizing lik of quasi deterministic response (phi and lambda -> 0)
        loc_Xtol_abs <- min(spaMM_tol$Xtol_abs, 1e-7 )
      } else loc_Xtol_abs <- spaMM_tol$Xtol_abs
      conv_rel_lambda <- all( abs(next_lambda_est-lambda_est) < spaMM_tol$Xtol_rel *lambda_est + loc_Xtol_abs) 
      conv.lambda <- ( conv_lambda_vs_u && conv_rel_lambda )  
      if (!is.null(next_randcoeff_cov_est)) {
        if (iter>1 && abs(randcoeff_cov_est-next_randcoeff_cov_est) < spaMM_tol$Xtol_rel ) { 
          conv.corr <- TRUE 
        } else conv.corr - FALSE       
        randcoeff_cov_est <- next_randcoeff_cov_est
      } else conv.corr <- TRUE
    } else { conv.lambda <- conv.corr <- TRUE } ## end if need_ranefPars_estim else...
    #
    iter <- iter+1L ## here first from 0 to 1
    ###### convergence: 
    if ( conv.phi && conv.lambda && conv.corr) {
      break 
    } else if (iter>=max.iter) { ## did not converge...
      break 
    } else { ## update and continue
      if ( is.null(phi.Fix)) phi_est <- next_phi_est
      if (models[[1]]=="etaHGLM") {
        if ( ! is.null(corr_est) ) {
          corr_est <- list(rho=.getPar(HLfit_corrPars,"rho")) ## not spaMM 3.0 
          #LMatrix est constant!= decomp$u
        }
        if (need_ranefPars_estim) { ## next_lambda_est/ next ranCoefs/ next rho adjacency available:
          if (any(ranCoefs_blob$isRandomSlope)) {
            LMatrices <- calcRanefPars_blob$next_LMatrices ## keep L factor of corr mats for all models 
            if (processed$sparsePrecisionBOOL && any(which_inner_ranCoefs)) {
              .update_precision_info(processed, LMatrices, which.="inner_ranCoefs")
            }
            ZAL <- .compute_ZAL(XMatrix=LMatrices, ZAlist=processed$ZAlist,as_matrix=( ! inherits(ZAL,"Matrix"))) 
            if ( ! LMMbool ) {
              ## ZAL is modified hence wranefblob must be modified (below) but also eta-> mu->GLMweights
              ## .makeCovEst1 may have reestimated beta but we do not take this into account nor any resulting change in the 'blobs'
              eta <- off + drop(processed$AUGI0_ZX$X.pv %*% beta_eta) + drop(ZAL %id*% v_h) 
              muetablob <- .muetafn(eta=eta,BinomialDen=processed$BinomialDen,processed=processed) 
            }
          }
          ###################################################################################################
          if ( FALSE && NCOL(processed$X_lambda)==1L) {## FR->FR this almost works ./.
            ## ./. mais voir premier exemple dans ?spaMMqui boucle...comprends pas  
            if (iter>2L) {
              loglam0 <- log(antepenul_lambda)  
              loglam1 <- log(penul_lambda)  
              loglam2 <- log(lambda_est[1L])  
              loglam3 <- log(next_lambda_est[1L])  
              slope1 <- (loglam2-loglam1)/(loglam1-loglam0)
              slope2 <- (loglam3-loglam2)/(loglam2-loglam1) ## FR->FR need to handle 0 denoms
              if ((abs(log(abs(slope2)))>log(1.05)) ##  <0.95 || abs(slope2)>1.05) ## estimate will not explode
                  && (logarg <- slope1/slope2)>0   
                  && abs(log(logarg))<0.1 # we are in geom phase
              ) {               
                geom_est_loglam <- loglam2+(loglam3-loglam2)/(1-slope2)
                print(c(iter,loglam0,loglam1,loglam2,loglam3,geom_est_loglam))
                if ( ! is.na(geom_est_loglam) && ! is.infinite(geom_est_loglam) ) {
                  geom_est_lam <- exp(geom_est_loglam)
                  next_lambda_est <- rep(geom_est_lam,length(next_lambda_est))
                } 
              } else {
                print(c(iter,loglam0,loglam1,loglam2,loglam3))
              }
            }
            antepenul_lambda <- penul_lambda
            penul_lambda <- lambda_est[1L]
          }
          ###################################################################################################
          # UPDATE:
          ##      in particular, also in the adjacency case if rho was updated but not the lambda param.
          lambda_est <- next_lambda_est
          wranefblob <- .updateW_ranefS(cum_n_u_h,rand.families,lambda_est,u_h,v_h) ## bc lambda was modified
        } 
      }
      if ( is.null(phi.Fix) || ( models[[1]]=="etaHGLM" && any(ranCoefs_blob$isRandomSlope) && ! LMMbool) ) { ## phi or (ZAL -> mu) modified
        w.resid <- .calc_w_resid(muetablob$GLMweights,phi_est) ## bc phi was updated. 'weinu', must be O(n) in all cases 
      }
      ## conv_logL either used to break the loop, Xor required only in last two iters for diagnostics 
      if (processed$break_conv_logL 
          || ( verbose["trace"])) {
        next_lik <- .calc_APHLs_from_ZX(auglinmodblob=auglinmodblob, which="p_v", processed=processed)$p_v
        # this does not depend on the latest ranPars estimates, sicne sXaug was not updated afterwards... 
        conv_logL <- abs(next_lik - prev_lik)/(0.1 + abs(next_lik)) < 1e-8 # ~ glm.fit convergence
        if (processed$break_conv_logL && conv_logL) break 
        prev_lik <- next_lik
      } else conv_logL <- NA
      ##
      if (verbose["trace"]) {
        print(paste("iteration ",iter,"; convergence criteria for phi, lambda, corr pars , conv_lambda_vs_u, conv_rel_lambda: ",
                    paste0(c( conv.phi , conv.lambda, conv.corr, 
                             conv_lambda_vs_u, conv_rel_lambda),collapse = " ")))
        if (models[[1]]=="etaHGLM" && need_simple_lambda) { 
          #print(range(logrel_crit))
          #print(range(reldlam_crit))
        }
      } 
    } 
    ##### end convergence block
  } ## end main loop while ( TRUE )
  ########################################
  ######### END main loop ################
  ########################################
  if (verbose["trace"]) {
    if (iter==max.iter) {
      mess <- paste("(beta,v)/lambda/phi iterations failed to converge in",max.iter,"iterations")
      message(mess)
    } else {
      message(paste("(beta,v)/lambda/phi iterations in HLfit() converged in",iter,"iterations"))
    }
  }
  #
  # if (max(abs(levyes$beta_eta-levno$beta_eta))>1e-6) browser("max(abs(levyes$beta_eta-levno$beta_eta))>1e-6")
  if (HL[1]=="SEM") {
    APHLs <- list(logLapp=logLapp) ## keeps attributes
    APHLs$clik <- .calc_clik(mu,phi_est,processed) ## useful for .get_info_crits()
  } else {
    if (models[[1]]=="etaHGLM") {
      if (identical(processed$return_only,"p_vAPHLs")) {
        whichAPHLs <- "p_v"
      } else if (identical(processed$return_only,"p_bvAPHLs")) {
        whichAPHLs <- "p_bv" ## retrun value may still include p_v if it is used to compute p_bv
      } else whichAPHLs <- c("p_v","p_bv")
      APHLs <- .calc_APHLs_from_ZX(auglinmodblob,which=whichAPHLs,processed)
    } else { 
      APHLs <- .calc_APHLs_from_ZX(auglinmodblob=NULL,processed, which="p_v",
                                          sXaug=NULL, phi_est, lambda_est=NULL, dvdu=NULL, u_h=NULL, mu ) 
    }
  }
  ######################### potential R E T U R N here: cases without p_bv
  if ( identical(processed$return_only,"p_vAPHLs")) {
    # a bit of ugly coding, but optimthroughsmooth calls HLCor, not HLCor.obj, thus it cannot directly control return_only. So either leave as is, or move the test to HLCor, or modify optimthroughsmooth to call HLCor.obj  
    if (HL[1]=="SEM") { # lambda used for smoothing.
      res <- list(APHLs=APHLs,lambda=SEMblob$lambda) 
    } else {
      res <- list(APHLs=APHLs) 
      if ( ! is.null(oldp_v <- processed$port_env$objective)) {
        .update_port_fit_values(old_obj=oldp_v,new_obj=APHLs$p_v, 
                                port_fit_values=list(fixef=beta_eta,v_h=v_h,phi_est=phi_est), 
                                models=models, processed=processed, control.HLfit=control.HLfit,
                                lambda_est=lambda_est, 
                                phifit=phifit)
      } else if ( ! identical(control.HLfit$write_port_env,FALSE)) {
        assign("objective",APHLs$p_v,envir=processed$port_env)
      }
    }
    return(res)   ########################   R E T U R N
  } 
  ## ELSE continue: make sur p_bv is included
  if (HL[1] != "SEM") {
    if (models[[1]]=="etaHGLM") {
      ## nothing to do as APHLs already contain p_bv.
      ## cf notes 19/08/2016 pour calcul APHLs et IC's for phiHGLM 
    } else { ## G L M
      ## ML: X.Re non NULL mais ncol(X.Re)=0
      X.REML <- X.Re
      if (is.null(X.Re)) {X.REML <- processed$AUGI0_ZX$X.pv} ## REML standard
      if ( ncol(X.REML) ) { ## REML standard || REML non standard
        Md2hdb2 <- .ZtWZwrapper(X.REML,w.resid)
        ladb <- .LogAbsDetWrap(Md2hdb2,logfac=-log(2*pi))
      } else ladb <- 0 ## fit ML standard : ncol(X.Re)=0, p_bv=p_v hence d2hdpbv reduces to d2hdv2
      APHLs <- list(p_v=APHLs$clik, p_bv=APHLs$clik - ladb/2) ## 07/2016 for inference about phi in GLMs 
    }
  }
  ######################### potential R E T U R N here: with p_bv
  if ( identical(processed$return_only,"p_bvAPHLs")) {
    if ( ! is.null(oldp_bv <- processed$port_env$objective)) {
      .update_port_fit_values(old_obj=oldp_bv,new_obj=APHLs$p_bv, 
                              port_fit_values=list(fixef=beta_eta,v_h=v_h,phi_est=phi_est), 
                              models=models, processed=processed, control.HLfit=control.HLfit,
                              lambda_est=lambda_est, 
                              phifit=phifit)
    } else if ( ! identical(control.HLfit$write_port_env,FALSE)) {
      assign("objective",APHLs$p_bv,envir=processed$port_env)
    }
    res <- list(APHLs=APHLs)
    return(res)    ########################   R E T U R N
  } 
  # beta_cov code removed from here in v1.9.24
  ######################
  ######################
  ######################
  ##### LAMBDA and other RANEF PARS
  # there is one lambda 
  ## FR->FR the code defines lambda.Fix as a vector with one element per ranef
  ## hence its not clear how lambda.Fix  is handled in this case
  ## but coefficients lambda (list) below may have a two-element vector in this case ?
  ## (1) we count inner-estimated ranef pars
  if (need_ranefPars_estim) {
    bloc_lambda_args <- list(models=models, 
                             processed=processed, lambda.Fix=lambda.Fix, 
                             cum_n_u_h=cum_n_u_h, next_LMatrices=LMatrices)
    if (HL[1]=="SEM") {
      bloc_lambda_args$SEMblob <- SEMblob
    } else {
      bloc_lambda_args$calcRanefPars_blob <- calcRanefPars_blob
      bloc_lambda_args$lev_lambda <- lev_lambda
    }
    #
    process_resglm_blob <- do.call(".bloc_lambda",bloc_lambda_args)
    #
    coefficients_lambdaS <- process_resglm_blob$coefficients_lambdaS # list
    p_lambda <- length( unlist(coefficients_lambdaS)) - length( which(attr(init.lambda,"type")=="fixed")) 
    p_adjd <- vector("list", length(coefficients_lambdaS) )
    for (it in seq_len(length(coefficients_lambdaS))) p_adjd <- which(names(coefficients_lambdaS[[it]])=="adjd") 
    p_adjd <- sum(unlist(p_adjd))
    p_lambda <- p_lambda + p_adjd
    var_ranCoefs <- with(ranCoefs_blob, (isRandomSlope & ! is_set))
    if (any(var_ranCoefs)) {
      p_corr <- vector("list", length(LMatrices))
      for (it in which(var_ranCoefs)) {
        dimL <- NROW(attr(LMatrices[[it]],"latentL_blob")$design_u)
        if (dimL==0L) stop("'Lcompact' attribute missing to LMatrices[[it]].")
        p_corr[[it]] <- (dimL-1)*dimL/2
      }
      p_corr <- sum(unlist(p_corr))
      p_lambda <- p_lambda+p_corr
    }
  } else {
    p_lambda <- 0
    process_resglm_blob <- list(print_lambdas=as.list(rep(NA,nrand)))
  }
  ## (2) we count outer estimated ones
  if (! is.null(preproFix <- processed$lambda.Fix))
  p_lambda <- p_lambda + length(which(is.na(preproFix[ ! is.na(lambda.Fix)])))
  ##### PHI: 
  # if (models[["phi"]]=="phiHGLM") {
  #   ## nothing to be done since we have a full fitme'd object. We could same some time by hacking _fitme_ 
  #   ##  so that it does not perform its final call but still returns the phi_est (ie its mu). Not urgent.
  # } # else nothing to do here, as the phi_GLM is built one request from summary() if missing 
  ######################################
  ## BUILD full RETURN VALUE
  ######################################
  #
  ###################
  ## LIKELIHOODS
  ###################
  res <- list(APHLs=APHLs)
  ###################
  ## DATA
  ###################
  res$data <- data ## very useful for simulate...
  if (family$family=="binomial") {
    res$BinomialDen <- BinomialDen
  }
  res$y <- y ## counts for Pois/bin
  #res$prior.weights <- structure(eval(prior.weights), unique=identical(attr(prior.weights,"unique"),TRUE)) ## see Gamma()$simulate
  res$prior.weights <- structure(eval(prior.weights), unique=attr(prior.weights,"unique")) ## see Gamma()$simulate
  ###################
  ## MODEL info
  ###################
  res$family <- family
  res$X.pv <- processed$AUGI0_ZX$X.pv
  if ( ! is.null(attr(res$X.pv,"scaled:scale"))) {
    beta_eta <- .unscale(beta=beta_eta, X=res$X.pv)
    res$X.pv <- .unscale(res$X.pv) ## usefully not in an environment
  } 
  res$ranFix <- ranFix ## currently as a uniform template consistent with projected changes ; except that lamFix, phiFix info is now in lambda.object, etc
  ## If an outer optimizer has been called,
  #  "fix" and "outer" parameters are given these types after the optimization call, then HLfit is called again and we reach this point.
  #  This means ranFix gets its type from there *if* properly retained by .canonizeRanPars() 
  #  Then we add inner-optimized parameters, with "var" type added by .get_CorrEst_and_RanFix()
  if ( ! is.null(corr_est) && ! is.null(init.HLfit$corrPars)) corr_est <- list(corrPars=relist(corr_est$rho,init.HLfit$corrPars)) ## not yet spaMM 3.0
  # Canonical, and inherits all info about outer-optimized corrPars through HLfit's ranFix argument:
  res$CorrEst_and_RanFix <- .get_CorrEst_and_RanFix(ranFix, corr_est) # corr_est parameters are inner-estimated and of type "var"
  #
  if ( ! is.null(res$CorrEst_and_RanFix$corrPars)) {
    p_corrPars <- length(which(unlist(attr(res$CorrEst_and_RanFix,"type")$corrPars) != "fix"))
    res$corrPars <- structure(res$CorrEst_and_RanFix$corrPars, # ## subset of the above: F I X M E (?) redundancy but convenient when examining fits
                              type=attr(res$CorrEst_and_RanFix,"type")$corrPars,
                              message='Use get_ranPars(.,which="corrPars") to extract "corrPars" cleanly from fit object.')
  } else p_corrPars <- 0  
  res$dfs <- c(pforpv=pforpv, p_lambda=p_lambda, p_fixef_phi=processed$p_fixef_phi, p_corrPars=p_corrPars)
  res$models <- models
  res$HLframes <- processed$HLframes ## used by predict
  res$predictor <- predictor ##  all post fitting functions expect PROCESSED predictor
  #
  if (models[[1]] == "etaHGLM") res$ZAlist <- processed$ZAlist ## needed for prediction variance
  res$REMLformula <- REMLformula ## copy without modif of processed$REMformula, given that 'processed' is not returned
  ###################
  ## OBJECTIVE and ALGORITHMs
  ###################
  res$HL <- HL ## info on fitting objective
  res$how <- list(spaMM.version=packageVersion("spaMM"),
                  MME_method=if (HL[1]!="SEM") { 
                    setdiff(class(auglinmodblob$sXaug),c("list"))
                  } else { "stochastic EM"},
                  switches=c(augZXy_cond=processed$augZXy_cond,
                             use_spprec_QR=.spaMM.data$options$use_spprec_QR)
                  )
  # !!! res$MME_method used later in this fn !!!
  res$MME_method <- structure(res$how$MME_method,
                              message="Please use how(<fit object>)[['MME_method']] to extract this information cleanly.")                 
  res$spaMM.version <- structure(res$how$spaMM.version, ## this is NOT a string and comparison with a string is suitably def'ed (as detailed in ?package_version)
                                 message="Please use how(<fit object>)[['spaMM.version']] to extract this information cleanly.")                 
  if (HL[1]=="SEM") res$SEM_info <- SEMblob$SEM_info ## info
  ###################
  ## FITTED VALUES
  ###################
  if (family$family=="binomial") {
    res$fv <- mu/BinomialDen ## cf glm(binomial): fitted values are frequencies 
  } else if (is.list(w.resid)) {
    res$fv <- structure(mu/(1-muetablob$p0), ## mu Truncated from mu Untruncated.
                        mu_U=mu,
                        p0=muetablob$p0) ## more efficient info for simulation.
  } else {res$fv <- mu} ## fitted values may be counts (cf poisson), or reals
  names(res$fv) <- rownames(data) ## otherwise it tends to get names given by .ULI(), with repeats...
  ###################
  ## FIXEF, ETA, ... 
  ###################
  ## Assuming beta_eta is a vector, not a matrix
  if ( ! is.null(namesOri <- attr(processed$AUGI0_ZX$X.pv,"namesOri"))) { ## includins NA's names (and etaFix$beta names)
    nc <- length(namesOri)
    beta_etaOri <- rep(NA,nc)
    names(beta_etaOri) <- namesOri
    beta_etaOri[names(beta_eta)] <- beta_eta ## keeps the original NA's
    beta_etaOri[names(etaFix$beta)] <- etaFix$beta  ## no longer in X.pv 2015/03
    res$fixef <- beta_etaOri ## fixme I should keep out the fixed ones for summary ? newetaFix code assumes the opposite
  } else {
    names(beta_eta) <- colnames(processed$AUGI0_ZX$X.pv)
    res$fixef <- beta_eta 
  } 
  res$eta <- eta ## convenient for defining starting values... and also sometimes used by predict()
  names(res$eta) <- rownames(data)
  res$muetablob <- muetablob # for get_logdispObject, added 11/2016
  ###################
  ## LEVERAGES and REML (ie either phi OR lambda was estimated)
  ###################
  if (HL[1]!="SEM") { ## both lev_phi and deviance_residual missing otherwise
    if (is.null(phi.Fix) || need_simple_lambda) { ## in either case all leverages are computed and it makes sense to consider the residuals
      res$lev_phi <- lev_phi
      dev_res <- family$dev.resids(y,mu,wt=1) * res$prior.weights
      res$std_dev_res <- sign(y-mu) * dev_res/(phi_est*(1-lev_phi)) ## should all have variance 1
    }
    if (need_simple_lambda) res$lev_lambda <- lev_lambda
  }  
  res$distinctX.Re <- X.Re ## NULL if not distinct from X.pv
  ###################
  ## ALL other LAMBDA returns
  ###################
  res$rand.families <- rand.families 
  ##
  res$ranef <- structure(u_h,cum_n_u_h=cum_n_u_h) ## FR->FR added cum_n_u_h attribute 11/2014: slightly duplicates info in lambda object
  res$v_h <- v_h
  res$QRmethod <- processed$QRmethod
  ## FR->FR $w.ranef and $w.resid not doc'ed, as there is no mention of the augmented mode lin the doc.
  if (identical(family$zero_truncated,TRUE)) {
    res$w.resid <- w.resid$w_resid ## useful for .get_info_crits() and get_LSmatrix()
  } else res$w.resid <- w.resid ## useful for .get_info_crits() and get_LSmatrix()
  if (models[["eta"]]=="etaHGLM") {
    res$sub_corr_info <- mget(c("corr_families","corr_types"), processed$corr_info) ## (AMatrices are kept as attribute to ZAlist)
    res$w.ranef <- wranefblob$w.ranef ## useful for .get_info_crits() and get_LSmatrix()
    #
    res$lambda.object <- .make_lambda_object(nrand, lambda_models=models[["lambda"]], cum_n_u_h, lambda_est, 
                                            process_resglm_blob,
                                            ZAlist, LMatrices, lambdaType=attr(init.lambda,"type"))
    # lambda.object$lambda is a list that contains lambdas for ranCoefs too !
    res$"lambda" <- structure(unlist(res$lambda.object$lambda),cum_n_u_h=cum_n_u_h) ## redundant but very convenient except for programming
    #### building a comprehensive list of descriptors of the structure of random effects:
    res$strucList <- .post_process_LMatrices(LMatrices, ZAlist, ranCoefs_blob=ranCoefs_blob) 
    ####
  } ## else all these res$ elements are NULL
  ###################
  ## ALL other PHI returns
  ###################
  res$resid.predictor <- processed$residModel$formula ## even if phi.Fix (04/2016), expected in summary of final hlcor call
  res$resid.family <- attr(processed$residModel$family,"quoted")  ## attribute used only for compact return
  # phi_est comes from calcPHIblob$next_phi_est, not from final glm,  hence is in minimal form
  if (models[["phi"]]=="phiScal") {res$phi <- phi_est[1L]} else res$phi <- phi_est
  if (is.null(phi.Fix)) {
    if (models[["phi"]]=="phiHGLM") {
      res$resid_fit <- phifit
    } else {
      beta_phi <- calcPHIblob$beta_phi 
      names_beta_phi <- names(beta_phi)
      for (it in seq_len(length(names_beta_phi))) {
        if (substr(names_beta_phi[[it]],1,1)=="X") names_beta_phi[[it]] <- substring(names_beta_phi[[it]],2)
      } ## removes "X" without guessing any order or length
      names(beta_phi) <- names_beta_phi 
      # FR->FR redundant info for summary, a nettoyer 
      phi.object <- list(fixef=beta_phi)
      phi.object$glm_phi <- calcPHIblob$glm_phi
      if (is.null(phi.object[["glm_phi"]])) {
        # delays computation of glm_phi
        glm_phi_args <- list(dev.res=dev_res*res$prior.weights,
                             control=processed[["control.glm"]],
                             etastart=rep(calcPHIblob$beta_phi,nobs)) ## no glm <=> formula was ~1
        phi.object <- c(phi.object, list(glm_phi_args=glm_phi_args ) )
      } 
      res$phi.object <- phi.object
    }
  } else {
    ## important distinction for (summary, df of LRTs:
    if (is.null(processed$phi.Fix)) { ## absent from original call
      res$phi.object <- list(phi_outer=structure(phi.Fix,type="var")) ## hlcor call of corrHLfit / HLfit call post fitme ?
    } else res$phi.object <- list(phi_outer=structure(phi.Fix,type="fix"))
  }
  ################### the magic environment
  res$envir <- list2env(list(dvdloglamMat=dvdloglamMat, dvdlogphiMat=dvdlogphiMat), ## provided if available
                        parent=environment(HLfit_body))
  if (models[[1L]]=="etaHGLM" && HL[1]!="SEM") {
    beta_cov_info <- get_from_MME(auglinmodblob$sXaug,"beta_cov") 
    res$envir$beta_cov_info <- .unscale_beta_cov_info(beta_cov_info, 
                                            sXaug=auglinmodblob$sXaug,
                                            X_scale=attr(processed$AUGI0_ZX$X.pv,"scaled:scale"))
    # in sparse precision beta_v_cov is not yet included
  }
  if ("AUGI0_ZX_sparsePrecision" %in% res$MME_method) { 
    ## for beta_v_cov and cAIC's p_d
    # These elements are protected from deletion in stripHLfit() by explicit setdiff(stripnames,c("G_CHMfactor",...)):
    res$envir$ZtW <- t(.Dvec_times_m_Matrix(attr(auglinmodblob$sXaug,"w.resid"),auglinmodblob$sXaug$AUGI0_ZX$ZAfix))
    BLOB <- auglinmodblob$sXaug$BLOB 
    res$envir$chol_Q <- BLOB$chol_Q ## 'res$BLOB' is actually 'res$envir'
    res$envir$G_CHMfactor <- BLOB$G_CHMfactor
    res$envir$qrXa <- BLOB$qrXa
    res$envir$X_scale <- BLOB$X_scale
  }
  ###################
  ## WARNINGS
  ###################
  .hack_options_error(message=NULL)
  ## translation of warnings in user-more friendly form ##FR -> FR  a revoir
  if ( ! is.null(warningList$resLam0) && warningList$resLam0) { 
    warningList$resLam0 <- "lambda residuals numerically 0 were replaced by 1e-6"
  }
  if ( ! is.null(warningList$resLamInf) && warningList$resLamInf) { 
    warningList$resLamInf <- "lambda residuals numerically >1e10 were replaced by 1e10"
  }
  if (! is.null(warningList$leveLam1) && warningList$leveLam1) {
    warningList$leveLam1 <- paste("lambda leverages numerically 1 were replaced by 1-",
                                  .spaMM.data$options$regul_lev_lambda,"(as controlled by option 'regul_lev_lambda')")
  }
  if ( ! is.null(warningList$resPhi0) && warningList$resPhi0) { 
    warningList$resPhi0 <- "phi residuals numerically 0 were replaced by 1e-6"
  }
  if ( ! is.null(warningList$resPhiInf) && warningList$resPhiInf) { 
    warningList$resPhiInf <- "phi residuals numerically >1e10 were replaced by 1e10"
  }
  if (! is.null(warningList$levePhi1) && warningList$levePhi1) {
    warningList$levePhi1 <- "phi leverages numerically 1 were replaced by 1 - 1e-8"
  }
  if (! is.null(warningList$negLevLam) && warningList$negLevLam) {
    warningList$negLevLam <- "Negative leverages for lambda were replaced by 1e-8"
  }
  if (! is.null(locw <- warningList$innerPhiGLM)) {
    warningList$innerPhiGLM <- paste0("'",locw,"' in some sub-final iteration(s) of phi estimation;")
  }
  if (! is.null(locw <- warningList$innerLamGLM)) {
    warningList$innerLamGLM <- paste0("'",locw,"' in some sub-final iteration(s) of lambda estimation;")
  }
  if ( HL[1]!="SEM" && maxit.mean>1 ## cases where iterations are needed 
      && ( ( models[[1]]=="etaHGLM"  && innerj==maxit.mean) 
           || 
           ( models[[1]]=="etaGLM" && pforpv>0L && innerj==maxit.mean)
        )) {
    
    warningList$innerNotConv <- paste0("linear predictor estimation did not converge;",
                                      if ( ! LMMbool && ! .determine_LevenbergM(processed$LevenbergM) ) {
                                         " try control.HLfit=list(LevenbergM=TRUE), or"
                                      },
                                      " increase 'max.iter.mean' above ",maxit.mean)
  }
  if ( (! is.na(conv_logL)) && iter==max.iter) {
    maxitmess <- paste0("Estimates did not converge;",
                       if ( ! LMMbool && ! .determine_LevenbergM(processed$LevenbergM) ) {
                         "trycontrol.HLfit=list(LevenbergM=TRUE), or"
                       },
                       " increase 'max.iter' above ",max.iter,
                       "\n (see help('HLfit') for details about 'max.iter')")
    if (models[["eta"]]=="etaHGLM") {
      if (conv_logL  && ! conv.lambda) {
        mainNotConv <- paste0("p_v apparently converged but lambda estimates apparently did not.",
                             "\n This may indicate that some lambda estimate(s) should be zero.",
                             "\n Otherwise try increasing 'max.iter' above ",max.iter,
                             "\n (see help(HLfit) for details about 'max.iter')")          
      } else mainNotConv <- maxitmess        
      attr(mainNotConv,"diagnostics") <- c( conv.phi=conv.phi , conv.lambda=conv.lambda, 
                                            conv.corr=conv.corr, conv_lambda_vs_u=conv_lambda_vs_u,
                                            conv_rel_lambda=conv_rel_lambda )
    } else {
      mainNotConv <- maxitmess        
      attr(mainNotConv,"diagnostics") <- c( conv.phi=conv.phi , conv.lambda=conv.lambda, 
                                            conv.corr=conv.corr )
    }
    warningList$mainNotConv <- mainNotConv
  }
  res$warnings <- warningList
  ###
  ### experimental cAIC minimization
  if ( identical(processed$return_only,"cAICAPHLs")) {
    #clik <- .calc_APHLs_from_ZX(auglinmodblob,which="clik",processed)$clik
    #d2hdv2 <- .calcD2hDv2(ZAL,w.resid,auglinmodblob$wranefblob$w.ranef) 
    #pd <- .calc_cAIC_pd(X.pv=processed$AUGI0_ZX$X.pv, ZAL, w.resid, d2hdv2)
    # but general code for p_phi is complex, whcih which we don't use the previous code (and early return) but this:
    APHLs <- .get_info_crits(res)["cAIC"]
    if ( ! is.null(oldcAIC <- processed$port_env$objective)) {
      .update_port_fit_values(old_obj= - oldcAIC,new_obj= - APHLs$cAIC, 
                              port_fit_values=list(fixef=beta_eta,v_h=v_h,phi_est=phi_est), 
                              models=models, processed=processed, control.HLfit=control.HLfit,
                              lambda_est=lambda_est, 
                              phifit=phifit)
    } else if ( ! identical(control.HLfit$write_port_env,FALSE)) {
      assign("objective",APHLs$cAIC,envir=processed$port_env)
    }
    res <- list(APHLs=APHLs)
    return(res)    ########################   R E T U R N
  }
  ###################
  ## SUMMARY, RETURN
  ###################
  class(res) <- c("HLfit",class(res)) 
  if (verbose["all_objfn_calls"]) {
    seriousWarnings <- warningList[intersect(c("innerNotConv","mainNotConv"),names(warningList))]
    if (length(seriousWarnings) ) { 
      warningsss <- paste0("In HLfit :\n",unlist(seriousWarnings))
      abyss <- sapply(warningsss, warning, call.=FALSE) 
      warningList[setdiff(names(warningList),c("innerNotConv","mainNotCov"))] <- NULL
    }
  } 
  if (verbose["trace"]) {
    if (length(warningList) ) {
      warningsss <- paste0(unlist(warningList),"\n")
      abyss <- sapply(warningsss,cat) 
    }
  }
  # cleanup: for diagnostic, use
  # sort(sapply(ls(<object>$envir), function(x)
  # +             object.size(get(x, envir = <object>$envir))),decreasing=TRUE)
  lsv <- c("lsv",ls())
  rm(list=setdiff(lsv,"res")) ## empties the whole local envir except the return value
  return(res)
}})