% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv.R
\name{nkde_worker_bw_sel}
\alias{nkde_worker_bw_sel}
\title{Worker function for bandwidth selection by likelihood cross validation}
\usage{
nkde_worker_bw_sel(
  lines,
  events,
  samples,
  kernel_name,
  bws,
  method,
  div,
  digits,
  tol,
  sparse,
  max_depth,
  verbose = FALSE
)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame representing the underlying network. The
geometries must be a SpatialLinesDataFrame (may crash if some geometries
 are invalid)}

\item{events}{A SpatialPointsDataFrame representing the events on the
network.}

\item{samples}{A SpatialPointsDataFrame representing the samples on the
network.}

\item{kernel_name}{The name of the kernel to use. Must be one of triangle,
gaussian, tricube, cosine ,triweight, quartic, epanechnikov or uniform.}

\item{bws}{A vector with all the bandiwdths to test.}

\item{method}{The method to use when calculating the NKDE, must be one of
simple / discontinuous / continuous (see details for more information)}

\item{div}{The divisor to use (should always be dist here).}

\item{digits}{The number of digits to retain in the spatial coordinates. It
ensures that topology is good when building the network. Default is 3}

\item{tol}{When adding the events and the sampling points to the network,
the minimum distance between these points and the lines' extremities. When
points are closer, they are added at the extremity of the lines.}

\item{sparse}{A Boolean indicating if sparse or regular matrix should be
used by the Rcpp functions. Regular matrix are faster, but require more
memory and could lead to error, in particular with multiprocessing. Sparse
matrix are slower, but require much less memory (not used for the moment).}

\item{max_depth}{when using the continuous and discontinuous methods, the
calculation time and memory use can go wild  if the network has many
small edges (area with many of intersections and many events). To
avoid it, it is possible to set here a maximum depth. Considering that the
kernel is divided at intersections, a value of 10 should yield good
estimates in most cases. A larger value can be used without a problem for the
discontinuous method. For the continuous method, a larger value will
strongly impact calculation speed.}

\item{verbose}{A Boolean, indicating if the function should print messages
about process.}

\item{agg}{A double indicating if the events must be aggregated within a distance.
If NULL, the events are aggregated by rounding the coordinates.}
}
\value{
A list of dataframes (continuous kernel) or a list of numeric vectors (other kernels).
}
\description{
The worker function for bandwidth selection by likelihood cross validation
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
