makegrid = function(x, n = 10000, nsig = 2, cellsize, offset = rep(0.5,nrow(bb))) {
	if (is(x, "Spatial"))
		bb = bbox(x)
	else
		bb = x
	# rx = bb[1,]
	# ry = bb[2,]
	if (missing(cellsize)) {
		pw = 1.0/nrow(bb)
		cellsize = signif((prod(apply(bb, 1, diff))/n) ^ pw, nsig)
	}
	if (length(cellsize) == 1)
		cellsize = rep(cellsize, nrow(bb))
# in some cases with small n, min* can be larger than bbox max values
# so guard imposed to step down from cellsize
	min.coords = pmax(bb[,1], signif(bb[,1] + offset * cellsize, nsig))
	# minx = max(rx[1], signif(rx[1] + offset[1] * cellsize, nsig))
	# miny = max(ry[1], signif(ry[1] + offset[2] * cellsize, nsig))
	expand.grid.arglist = list()
	for (i in 1:nrow(bb)) {
		name = paste("x", i, sep = "")
		sign = ifelse(min.coords[i] < bb[i,2], 1, -1)
		expand.grid.arglist[[name]] = seq(min.coords[i], bb[i,2], sign * cellsize[i])
	}
	# if (minx < rx[2]) seqx = seq(minx, rx[2], by = cellsize)
	# else seqx = seq(minx, rx[2], by = -cellsize)
	# if (miny < ry[2]) seqy = seq(miny, ry[2], by = cellsize)
	# else seqy = seq(miny, ry[2], by = -cellsize)
	# type = "regular" :
	xy = do.call("expand.grid", expand.grid.arglist)
	attr(xy, "cellsize") = cellsize
	return(xy)
}

sample.Spatial = function(x, n, type, bb = bbox(x), offset = runif(nrow(bb)), cellsize, ...) {
	if (type == "random")
		xy = apply(bb, 1, function(x) runif(n) * diff(x) + x[1])
	else {
		xy = makegrid(bb, n = n, nsig = 20, cellsize = cellsize, offset = offset)
		cellsize = attr(xy, "cellsize")
		if (type == "stratified") {
			n = nrow(xy)
			for (j in 1:ncol(xy))
				xy[,j] = xy[,j] + (runif(n) - 0.5) * cellsize[j]
			#apply(xy, 2, function(x) x + (runif(n) - 0.5) * cellsize[1])
			# xy$x = xy$x + (runif(n) - 0.5) * cellsize
			# xy$y = xy$y + (runif(n) - 0.5) * cellsize
		} else if (type == "nonaligned") {
			if (ncol(xy) != 2)
				stop("sorry, nonaligned is only implemented for 2D")
			nx = length(unique(xy[,1]))
			ny = length(unique(xy[,2]))
			x0 <- rep(runif(ny), rep(nx, ny))
			y0 <- rep(runif(nx), ny)
			xy[,1] = xy[,1] + (x0 - 0.5) * cellsize[1]
			xy[,2] = xy[,2] + (y0 - 0.5) * cellsize[2]
		} else if (type != "regular")
			stop(paste("sampling type", type, "not recognized"))
	}
	SpatialPoints(xy, CRS(proj4string(x)))
}
setMethod("spsample", signature(x = "Spatial"), sample.Spatial)

sample.Line = function(x, n, type, offset = runif(1),
proj4string=CRS(as.character(NA)), ...) {
#...) {
	cc = coordinates(x)
	dxy = apply(cc, 2, diff)
	if (inherits(dxy, "matrix"))
		lengths = apply(dxy, 1, function(x) sqrt(sum(x ** 2)))
	else # cc has 2 rows:
		lengths = sqrt(sum(dxy ** 2))
	csl = c(0, cumsum(lengths))
	maxl = csl[length(csl)]
	if (type == "random")
		pts = runif(n) * maxl 
	else if (type == "stratified")
		pts = ((1:n) - runif(n))/n * maxl
	else if (type == "regular")
		pts = ((1:n) - offset)/n * maxl
	else
		stop(paste("type", type, "not available for Line"))
	# find coordinates:
	int = findInterval(pts, csl, all.inside = TRUE)
	where = (pts - csl[int])/diff(csl)[int]
	xy = cc[int,] + where * (cc[int+1,] - cc[int,])
#	SpatialPoints(xy, CRS(proj4string(x)))
	SpatialPoints(xy, proj4string=proj4string)
}
setMethod("spsample", signature(x = "Line"), sample.Line)

sample.Polygon = function(x, n, type = "random", bb = bbox(x),
		offset = runif(2), proj4string=CRS(as.character(NA)), iter=4, ...) {
#...) {
	area = getPolygonAreaSlot(x)
	if (area == 0.0)
		spsample(Line(getPolygonCoordsSlot(x)), 
			n, type, offset = offset[1], proj4string=proj4string)
#CRS(proj4string(x))), n, type, offset = offset[1])
	else {
		res <- NULL
		its <- 0
		n_now <- 0
		bb.area = prod(apply(bb, 1, function(x) diff(range(x))))
	        bb.area <- bb.area + bb.area*its*0.1
		xSP <- new("Spatial", bbox=bbox(x), proj4string=proj4string)
		if (type == "random") {
		    brks <- c(1,3,6,10,20,100)
		    reps <- c(5,4,3,2,1.5)
		    n_is <- round(n * reps[findInterval(n,
			brks, all.inside=TRUE)] * bb.area/area)
		} else n_is <- round(n * bb.area/area)
		while (is.null(res) && its < iter && n_is > 0 && 
		    ifelse(type == "random", (n_now < n), TRUE)) {
		    pts = sample.Spatial(xSP, n_is, type=type, 
			offset = offset, ...)
		    id = overlay(pts, SpatialPolygons(list(Polygons(list(x),
			"xx")), proj4string=proj4string))
		    Not_NAs <- !is.na(id)
		    if (!any(Not_NAs)) res <- NULL
		    else res <- pts[which(Not_NAs)]
		    if (!is.null(res)) n_now <- nrow(res@coords)
		    its <- its+1
		}
		if (!is.null(res) && n < nrow(res@coords) && type == "random") 
			res <- res[sample(nrow(res@coords), n)]
		res
	}
}
setMethod("spsample", signature(x = "Polygon"), sample.Polygon)

sample.Polygons = function(x, n, type = "random", bb = bbox(x),
		offset = runif(2), 
#...) {
proj4string=CRS(as.character(NA)), iter=4, ...) {
	#stop("not functioning yet...")
	area = sapply(getPolygonsPolygonsSlot(x), getPolygonAreaSlot) # also available for Polygons!
	if (sum(area) == 0.0)
		# distribute n over the lines, according to their length?
		stop("sampling over multiple lines not functioning yet...")
	res <- NULL
	its <- 0
	holes <- sapply(getPolygonsPolygonsSlot(x), getPolygonHoleSlot)
	pls <- getPolygonsPolygonsSlot(x)
	smple <- rep(TRUE, length(pls))
	if (length(pls) > 1) {
	    for (i in seq(along=pls)) {
		bbi <- .bbox2SPts(bbox(pls[[i]]), proj4string=proj4string)
		bb_in <- lapply(pls[-i], function(x, pts) 
			pointsInPolygon(pts, x), pts = bbi)
		if (holes[i] || any(unlist(bb_in) > 0)) smple[i] <- FALSE
	    }
	}
	sum_area <- sum(area[smple])
	while (is.null(res) && its < iter) {
	    ptsres <- vector(mode="list", length=length(area))
	    for (i in seq(along=ptsres)) {
		if (smple[i]) ptsres[[i]] <- sample.Polygon(
		    x=pls[[i]], n=round(n*(area[i]/sum_area)), 
		    type = type, offset = offset, proj4string=proj4string, 
		    iter=iter)
	    }
	    crds <- do.call("rbind", lapply(ptsres, function(x) 
	        if (!is.null(x)) coordinates(x)))
	    if (is.null(crds)) res <- NULL
	    else {
	        pts <- SpatialPoints(crds, proj4string=proj4string)
	        id = overlay(pts, SpatialPolygons(list(x), 
		    proj4string=proj4string))
	        Not_NAs <- !is.na(id)
	        if (!any(Not_NAs)) res <- NULL
	        else res <- pts[which(Not_NAs)]
	        if (nrow(res@coords) < n) res <- NULL
	    }
	    its <- its+1
	}
	if (!is.null(res) && n < nrow(res@coords) && type == "random") 
		res <- res[sample(nrow(res@coords), n)]
	res
}
setMethod("spsample", signature(x = "Polygons"), sample.Polygons)

sample.SpatialPolygons = function(x, n, type = "random", bb = bbox(x),
		offset = runif(2), iter=4, ...) {
	#stop("not functioning yet...")
	area = sum(unlist(lapply(getSpPpolygonsSlot(x),getPolygonAreaSlot)))
	if (area <= 0.0)
		stop("cannot sample in zero-area polygons")
	res <- NULL
	its <- 0
	while (is.null(res) && its < iter) {
	    bb.area = prod(apply(bb, 1, function(x) diff(range(x))))
	    bb.area <- bb.area + bb.area*its*0.1
	    pts = #spsample(as(x, "Spatial")
sample.Spatial(as(x, "Spatial"), round(n * bb.area/area), type=type, offset = offset, ...)
	    Over_pts_x <- overlay(pts, x)
	    Not_NAs <- !is.na(Over_pts_x)
	    if (!any(Not_NAs)) res <- NULL
	    else res <- pts[which(Not_NAs)]
	    if (nrow(res@coords) < n) res <- NULL
	    its <- its+1
	}
	if (!is.null(res) && n < nrow(res@coords) && type == "random") 
		res <- res[sample(nrow(res@coords), n)]
	res
}
setMethod("spsample", signature(x = "SpatialPolygons"), sample.SpatialPolygons)

sample.Sgrid = function(x, n, type = "random", bb = bbox(x),
		offset = runif(nrow(bb)), ...) {
	area = areaSpatialGrid(x)
	if (area == 0.0)
		stop("cannot sample from grid with zero area")
	pts = spsample(as(x, "Spatial"), n, type, offset = offset, ...)
	#id = overlay(as(x, "SpatialGrid"), pts)
	id = overlay(x, pts)
	if (is(id, "SpatialPointsDataFrame"))
		id = id@data[[1]]
	pts[which(!is.na(id))]
}
setMethod("spsample", signature(x = "SpatialGrid"), sample.Sgrid)

sample.Spixels = function(x, n, type = "random", bb = bbox(x),
		offset = runif(nrow(bb)), ...) {
	area = areaSpatialGrid(x)
	if (area == 0.0)
		stop("cannot sample from grid with zero area")
	bb.area = prod(apply(bb, 1, function(x) diff(range(x))))
	pts = spsample(as(x, "Spatial"), round(n * bb.area/area), type, offset = offset, ...)
	id = overlay(x, pts)
	if (is(id, "SpatialPointsDataFrame"))
		id = id@data[[1]]
	pts[which(!is.na(id))]
}
setMethod("spsample", signature(x = "SpatialPixels"), sample.Spixels)
