% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{getEntropy}
\alias{getEntropy}
\title{Entropy}
\usage{
getEntropy(x, type = c("weiner", "shannon")[1], normalize = FALSE,
  convertNonPositive = 1e-10)
}
\arguments{
\item{x}{vector of positive floats}

\item{type}{'shannon' for Shannon (information) entropy, 'weiner' for Weiner
entropy}

\item{normalize}{if TRUE, Shannon entropy is normalized by the length of
input vector to range from 0 to 1. It has no affect on Weiner entropy}

\item{convertNonPositive}{all non-positive values are converted to
\code{convertNonPositive}}
}
\description{
Returns Weiner or Shannon entropy of an input vector such as the spectrum of
a sound. Non-positive input values are converted to a small positive number
(convertNonPositive). If all elements are zero, returns NA.
}
\examples{
# Here are four simplified power spectra, each with 9 frequency bins:
s = list(
  c(rep(0, 4), 1, rep(0, 4)),       # a single peak in spectrum
  c(0, 0, 1, 0, 0, .75, 0, 0, .5),  # perfectly periodic, with 3 harmonics
  rep(0, 9),                        # a silent frame
  rep(1, 9)                         # white noise
)

# Weiner entropy is ~0 for periodic, NA for silent, 1 for white noise
sapply(s, function(x) round(getEntropy(x), 2))

# Shannon entropy is ~0 for periodic with a single harmonic, moderate for
# periodic with multiple harmonics, NA for silent, highest for white noise
sapply(s, function(x) round(getEntropy(x, type = 'shannon'), 2))

# Normalized Shannon entropy - same but forced to be 0 to 1
sapply(s, function(x) round(getEntropy(x,
  type = 'shannon', normalize = TRUE), 2))
}
