% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counting_function.R
\name{counting_function}
\alias{counting_function}
\title{Count number of function evaluations}
\usage{
counting_function(fn)
}
\arguments{
\item{fn}{[\code{soo_function}]\cr A test function.}
}
\description{
Return a new function which is identical to the  \code{\link{soo_function}}
passed in except that all function evaluations are counted.
}
\examples{
f <- counting_function(generate_double_sum_function(5))
number_of_evaluations(f)

y <- f(random_parameters(1, f))
number_of_evaluations(f)

reset_evaluation_counter(f)
number_of_evaluations(f)

y <- f(random_parameters(21, f))
number_of_evaluations(f)

}
\seealso{
\code{\link{number_of_evaluations}},
         \code{\link{reset_evaluation_counter}}
}
