% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_unload.R
\name{core_unload}
\alias{core_unload}
\title{Unload (delete) a core}
\usage{
core_unload(name, deleteIndex = FALSE, deleteDataDir = FALSE,
  deleteInstanceDir = FALSE, async = NULL, raw = FALSE,
  callopts = list())
}
\arguments{
\item{name}{The name of one of the cores to be removed. Required}

\item{deleteIndex}{(logical)    If \code{TRUE}, will remove the index when unloading
the core. Default: \code{FALSE}}

\item{deleteDataDir}{(logical)    If \code{TRUE}, removes the data directory and all
sub-directories. Default: \code{FALSE}}

\item{deleteInstanceDir}{(logical)    If \code{TRUE}, removes everything related to
the core, including the index directory, configuration files and other related
files. Default: \code{FALSE}}

\item{async}{(character) Request ID to track this action which will be processed
asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Unload (delete) a core
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg: bin/solr start -e schemaless

# connect
solr_connect()

# Create a core
core_create(name = "thingsstuff")

# Unload a core
core_unload(name = "fart")
}
}

