% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.lib.R
\name{plotKinship2}
\alias{histKinship2}
\alias{imageKinship2}
\alias{plotKinship2}
\title{Plot the double kinship matrix}
\usage{
plotKinship2(x, y = c("image", "hist"))

imageKinship2(x)

histKinship2(x)
}
\arguments{
\item{x}{A square matrix of double kinship coefficients.}

\item{y}{A character, the type of the plot.
   Possible values are \code{"image"} and \code{"hist"}.
   The default value is \code{"image"}.}
}
\description{
The main function that calls \code{imageKinship2} or \code{histKinship2}
depending on value of \code{y} argument.
}
\details{
\code{imageKinship2} function calls \code{image} function from \code{Matrix} package.

\code{histKinship2} function plots a histogram based on \code{ggplot2} package.
}
\examples{
# load `kin` kinship matrix from `dat50` data set
data(dat50)
kin2 <- 2* kin # double kinship matrix

plotKinship2(kin2) # equivalent to `imageKinship2(kin2)`

plotKinship2(kin2, "hist") # equivalent to `histKinship2(kin2)`
}

