% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchNOAA.R
\name{get_NOAA_stations_nearXY}
\alias{get_NOAA_stations_nearXY}
\title{Get NOAA station data near a given latitude and longitude}
\usage{
get_NOAA_stations_nearXY(lat, lng, apitoken, bbox = 1, crs = "EPSG:4326")
}
\arguments{
\item{lat}{Latitude or Y coordinate in \code{crs}}

\item{lng}{Longitude or X coordinate in \code{crs}}

\item{apitoken}{API key token for NOAA NCDC web service}

\item{bbox}{Optional: Dimension of the bounding box centered at \code{lat}, \code{lng}.}

\item{crs}{Coordinate Reference System. Default \code{"EPSG:4326"}}
}
\value{
data.frame containing station information for all stations within a bounding box around \code{lat}, \code{lng}.
}
\description{
Query the NOAA API to get station data (limit 1000 records) near a point. Default extent is plus or minus 0.5 degrees (bounding box) (with \code{bbox = 1}) around the specified point [lat, lng].

In order to use this function, you must obtain an API token from this website: https://www.ncdc.noaa.gov/cdo-web/token
}
\examples{

## in order to use this function, you must obtain an API token from this website:
##  https://www.ncdc.noaa.gov/cdo-web/token

# stations <- get_NOAA_stations_nearXY(lat = 37, lng = -120,
#                                      apitoken = "yourtokenhere")

}
