% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmsmurf_control.R
\name{glmsmurf.control}
\alias{glmsmurf.control}
\title{Control Function for Fitting a Multi-Type Regularized GLM Using the SMuRF Algorithm.}
\usage{
glmsmurf.control(
  epsilon = 1e-08,
  maxiter = 10000,
  step = NULL,
  tau = 0.5,
  reest = TRUE,
  lambda.vector = NULL,
  lambda.min = NULL,
  lambda.max = NULL,
  lambda.length = 50L,
  lambda.reest = FALSE,
  k = 5L,
  oos.prop = 0.2,
  validation.index = NULL,
  ncores = NULL,
  po.ncores = NULL,
  print = FALSE
)
}
\arguments{
\item{epsilon}{Numeric tolerance value for stopping criterion. A numeric strictly larger than 0, default is \code{1e-8}.}

\item{maxiter}{Maximum number of iterations of the SMuRF algorithm. A numeric larger than or equal to 1, default is \code{10 000}.}

\item{step}{Initial step size, a numeric strictly larger than 0 or \code{NULL}. When \code{NULL} (default), it is equal to \code{0.1} times the sample size.}

\item{tau}{Parameter for backtracking the step size. A numeric strictly between 0 and 1, default is 0.5.}

\item{reest}{A logical indicating if the obtained (reduced) model is re-estimated using \code{\link[speedglm]{speedglm}} or \code{\link[stats]{glm}}. Default is \code{TRUE}.}

\item{lambda.vector}{Values of lambda to consider when selecting the optimal value of lambda. A vector of strictly positive numerics (which is preferably a decreasing sequence as we make use of warm starts) or \code{NULL} (default).
When \code{NULL}, it is set to an exponential decreasing sequence of length \code{lambda.length} between \code{lambda.max} and \code{lambda.min}.}

\item{lambda.min}{Minimum value of lambda to consider when selecting the optimal value of lambda. A strictly positive numeric or \code{NULL} (default).
When \code{NULL}, it is equal to \code{0.0001} times \code{lambda.max}. This argument is ignored when \code{lambda.vector} is not \code{NULL}.}

\item{lambda.max}{Maximum value of lambda to consider when selecting the optimal value of lambda. A strictly positive numeric larger than \code{lambda.min} or \code{NULL} (default).
In the latter case, \code{lambda.max} will be determined based on the used penalty types such that it is one of the smallest values of lambda that results in an intercept-only model. This argument is ignored when \code{lambda.vector} is not \code{NULL}.}

\item{lambda.length}{Number of lambda values to consider when selecting the optimal value of lambda. A strictly positive integer, default is 50. This argument is ignored when \code{lambda.vector} is not \code{NULL}.}

\item{lambda.reest}{Logical indicating if the re-estimated coefficients are used when selecting lambda, default is \code{FALSE}.
This argument is only used if \code{reest} is \code{TRUE}.}

\item{k}{Number of folds when selecting lambda using cross-validation. A strictly positive integer, default is 5 (i.e. five-fold cross-validation). This number cannot be larger than the number of observations. Note that cross-validation with one fold (\code{k=1}) is the same as in-sample selection of \code{lambda}.}

\item{oos.prop}{Proportion of the data that is used as the validation sample when selecting \code{lambda} out-of-sample. A numeric strictly between 0 and 1, default is 0.2.
This argument is ignored when \code{validation.index} is not \code{NULL}.}

\item{validation.index}{Vector containing the row indices of the data matrix corresponding to the observations that are used as the validation sample.
This argument is only used when \code{lambda} is selected out-of-sample. Default is \code{NULL} meaning that randomly 100*\code{oos.prop}\% of the data are used as validation sample.}

\item{ncores}{Number of cores used when performing cross-validation. A strictly positive integer or \code{NULL} (default). 
When \code{NULL}, \code{max(nc-1,1)} cores are used where \code{nc} is the number of cores as determined by \code{\link{detectCores}}.}

\item{po.ncores}{Number of cores used when computing the proximal operators. A strictly positive integer or \code{NULL} (default).
When \code{NULL} or \code{ncores > 1}, \code{po.ncores} is set to 1.}

\item{print}{A logical indicating if intermediate results need to be printed, default is \code{FALSE}.}
}
\value{
A list with elements named as the arguments.
}
\description{
Control function to handle parameters for fitting a multi-type regularized generalized linear model (GLM) using the SMuRF algorithm.
The function sets defaults and performs input checks on the provided parameters.
}
\details{
More details on the selection of lambda can be found in the package vignette.
}
\examples{
## See example(plot_lambda) for examples 
}
\seealso{
Fitting procedures: \code{\link{glmsmurf}} and \code{\link{glmsmurf.fit}} (given design matrix). \code{\link[stats]{glm.control}}
}
