% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{plot3d.smAPC}
\alias{plot3d.smAPC}
\title{Presents demographic data as a 3D surface}
\usage{
\method{plot3d}{smAPC}(x, component = c("all", "surface", "period", "cohort",
  "residuals", "original"), labs = c("Age", "Time", NA),
  color.palette = c("default", "special"), ...)
}
\arguments{
\item{x}{Result of smoothing (object of class \code{smAPC}).}

\item{component}{"smooth", "period", "cohort", "residuals" or "original".}

\item{labs}{Vector of labels for X, Y and Z axes.}

\item{color.palette}{Character string \code{"default"} or \code{"special"} or a function accepting one argument and returning a color palette
(for example \code{\link[grDevices]{rainbow}}).}

\item{...}{Other parameters. They are currently ignored.}
}
\description{
Presents demographic data as a 3D surface
}
\examples{
\dontrun{

library(demography)
m <- log(fr.mort$rate$female[1:30, 150:160])
sm <- autoSmoothAPC(m)

plot3d(sm)
plot3d(sm, "surface", color.palette = "special")
plot3d(sm, "cohort")
plot3d(sm, "period")
plot3d(sm, "residuals")
plot3d(sm, "original", color.palette = rainbow)

}
}
\author{
Alexander Dokumentov
}

