% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm.R
\name{simulate.mm}
\alias{simulate.mm}
\title{Simulates k-th order Markov chains}
\usage{
\method{simulate}{mm}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{An object of class \link{mm}.}

\item{nsim}{An integer or vector of integers (for multiple sequences)
specifying the length of the sequence(s).}

\item{seed}{Optional. \code{seed} for the random number generator.
If no \code{seed} is given, then seed is set by using the command
\verb{set.seed(round(as.numeric(Sys.time()))}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of vectors representing the sequences.
}
\description{
Simulates k-th order Markov chains.
}
\details{
If \code{nsim} is a single integer then a chain of that length is
produced. If \code{nsim} is a vector of integers, then \code{length(nsim)}
sequences are generated with respective lengths.
}
\examples{
states <- c("a", "c", "g", "t")
s <- length(states)
k <- 2
vect.init <- rep.int(1 / s ^ k, s ^ k)
p <- matrix(0.25, nrow = s ^ k, ncol = s)

# Specify the Markov model
markov1 <- mm(states = states, init = vect.init, ptrans = p, k = k)

seq1 <- simulate(object = markov1, nsim = c(1000, 10000, 2000), seed = 150)
seq1[[1]][1:15]

}
\seealso{
\link{mm}, \link{fitmm}
}
