% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/testFunctions.R
\name{branin}
\alias{branin}
\title{Branin-Hoo 2-dimensional test function}
\usage{
branin(x)
}
\arguments{
\item{x}{Numeric vector with length 2.}
}
\value{
The Branin-Hoo function's value.
}
\description{
Branin-Hoo 2-dimensional test function.
}
\details{
The Branin-Hoo function is defined here over \eqn{[0,\,1] \times
[0,\,1]}{[0, 1] x [0, 1]}, instead of \eqn{[-5,\,0] \times
[10,\,15]}{[-5, 0] x [10, 15]} as usual.  It has 3 global minima
at (nearly) : \eqn{\mathbf{x}_1 = [0.96, \,0.15]^\top}{x1 = c(0.96, 0.15)},
\eqn{\mathbf{x}_2 = [0.12, \,0.82]^\top}{x2 = c(0.12, 0.82)}
and \eqn{\mathbf{x}_3 = [0.54,\,0.15]^\top}{x3 = c(0.54, 0.15)}.
}
\examples{
GD <- Grid(nlevels = c("x" = 20, "y" = 20))
x <- levels(GD)[[1]]; y <- levels(GD)[[2]]
f  <- apply_Grid(GD, branin)
dim(f) <- nlevels(GD)
contour(x = x, y = y, z = f, nlevels = 40)
nOut <- 100; Xout2 <- array(runif(nOut * 2), dim = c(nOut, 2))
colnames(Xout2) <- c("x", "y")

## interpolate using default method (Lagrange)
GIL <- interp_Grid(X = GD, Y = f, Xout = Xout2)

## interpolate using a natural spline
GIS <- interp_Grid(X = GD, Y = f, Xout = Xout2,
                 cardinalBasis1d = function(x, xout) {
                     cardinalBasis_natSpline(x = x, xout = xout)$CB
                  })
F <- apply(Xout2, 1, branin)
mat <- cbind(Xout2, fTrue = F, fIntL = GIL, errorLag = F - GIL,
             fIntS = GIS, errorSpline = F - GIS)
apply(mat[ , c("errorLag", "errorSpline")], 2, function(x) mean(abs(x)))
\dontrun{
## for the users of the "rgl" package only...
library(rgl)
persp3d(x = x, y = y, z = f, aspect = c(1, 1, 0.5), col = "lightblue", alpha = 0.8)
spheres3d(Xout2[ , 1], Xout2[ , 2], GIS, col = "orangered",
          radius = 2)
}
}
\author{
David Ginsbourger
}

