% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{comp_tapmat_cov}
\alias{comp_tapmat_cov}
\title{Wendland-1 covariance function for a polygons.}
\usage{
comp_tapmat_cov(cross_dists, n, n2, sigsq, phi, nu, theta)
}
\arguments{
\item{cross_dists}{a \code{list} such that each position contains the cross
distances between points within different polygons.}

\item{n}{an ingeger representing number of polygons (note that, this is
different than the size of the list \code{cross_dists}}

\item{n2}{usually, equal to \code{n}, except when the function is being used
to calculate the "cross" covariance between two different partitions of
the same space.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function}

\item{nu}{the smoothness parameter \eqn{\nu} parameter from the Matern
covariance function}

\item{theta}{the taper distance.}
}
\value{
The wendland-1 covariance matrix associated with a set of polygons.
}
\description{
Computing the Matern covariance function between polygons.
}
\keyword{internal}
