% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.zones.R
\name{fast.zones}
\alias{fast.zones}
\title{Determine sequence of fast subset scan zones}
\usage{
fast.zones(cases, pop, ubpop = 0.5, simple = TRUE)
}
\arguments{
\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{simple}{A logical value indicating whether a simple
version of the fast zones should be returned.  See
Details.}
}
\value{
Returns a vector of regions to sequentially and
  cumulatively consider for clustering.
}
\description{
\code{fast.zones} determines the unique zones obtained by
implementing the fast subset scan method of Neill (2012).
}
\details{
The \code{simple} argument determines the formatting of
the returned zones.  If \code{simple = TRUE}, then a
vector containing the sequential indices of the regions
in each successive zones is returned.  If \code{simple =
FALSE}, then the complete list of all zones is returned
(which is the standard format of most of the other
\code{*.zones} functions.

The zones returned must have a total population less than
\code{ubpop * sum(pop)} of all regions in the study area.
}
\examples{
data(nydf)
cases = nydf$cases
pop = nydf$pop
# compare output format
fast.zones(cases, pop, ubpop = 0.05)
fast.zones(cases, pop, ubpop = 0.05, simple = FALSE)
}
\references{
Neill, D. B. (2012), Fast subset scan for
  spatial pattern detection. Journal of the Royal
  Statistical Society: Series B (Statistical
  Methodology), 74: 337-360.
  <doi:10.1111/j.1467-9868.2011.01014.x>
}
\author{
Joshua French
}
