% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.psi}
\alias{smbinning.psi}
\title{Population Stability Index}
\usage{
smbinning.psi(df, y, x)
}
\arguments{
\item{df}{Data frame.}

\item{y}{Column name the indicates the different partitions.}

\item{x}{Feature to be evaluated in terms of stability (It must be factor).}
}
\value{
Three crosstabs by feature and period that show the frequency (psicnt), 
percentage (psipct) and PSI (psimg), and a plot for the analyzed characteristic.
}
\description{
Often models are developed using multiple periods in time for a number of reasons.
For example, to avoid seasonality, to increase the size of the population, and some others.
With a metrics like the Population Stability Index (PSI), users can check if there is
a significant variation in the distribution of a certain feature by partition (usually time)
using the first one as the reference.
}
\examples{
# Load library and its dataset
library(smbinning)

# Check stability for income
smbinning.psi(df=chileancredit,y="period",x="inc") 
}
