% Generated by roxygen2 (4.0.2): do not edit by hand
\name{logrr}
\alias{logrr}
\title{Log ratio of spatial densities}
\usage{
logrr(f, g)
}
\arguments{
\item{f}{An object from the \code{spdensity} function.  Typically is related to the "cases".}

\item{g}{An object from the \code{spdensity} function.  Typically is related to the "controls".}
}
\value{
The function produces an object of the same type as the \code{density.ppp} function from the \code{spatstat} package, with the intensity values replaces by the log ratio of the spatial densities f and g.
}
\description{
\code{logrr} computes the log ratio of spatial density functions.  This ratio is within an additive constant of the log relative risk.  The numerator in this ratio is related to the "cases" and the denominator to the "controls".
}
\examples{
data(grave)
cases = which(grave$marks == "affected")
f = spdensity(grave[cases,], sigma = 700)
g = spdensity(grave[-cases,], sigma = 700)
contour(logrr(f, g))
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kelsall, Julia E., and Peter J. Diggle. "Kernel estimation of relative risk." Bernoulli (1995): 3-16.  Kelsall, Julia E., and Peter J. Diggle. "Non-parametric estimation of spatial variation in relative risk." Statistics in Medicine 14.21-22 (1995): 2335-2342.
}

