%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.scale.box}
\alias{plot.scale.box}

\title{Box plots for microarray}
\description{
Produce box-and-whisker plot(s) of the given (grouped) values.
}
\usage{
plot.scale.box(x, layout, x.names=NULL, ...)
}

\arguments{
  \item{x}{a vector or a matrix.}
  \item{layout}{ a list specifying the dimensions of the spot matrix
   and the grid matrix.  This can be generated by calling
   \code{\link{init.grid}}.}
  \item{x.names}{group labels which will be printed under each boxplot.}
  \item{\dots}{further arguments to the default boxplot method and graphical
    parameters may also be passed as arguments, see \code{\link{par}}.}
}
\details{
  If x is a vector, this function will produce n boxplots where n is
  number of print-tips groups.   If x is a matrix, this function will
  produce n boxplots where n is number of columns in the matrix.  
}

\author{Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu}}

\seealso{\code{\link{boxplot}}, \code{\link{bxp}}}

\examples{
     data(MouseArray)
     # mouse.setup <- init.grid() 
     # mouse.data <- init.data() ## see \emph{init.data} 
     mouse.lratio <- stat.ma(mouse.data, mouse.setup)
     ## Producing boxplots for different print-tips groups.
     plot.scale.box(mouse.lratio$M[,1], mouse.setup)
     ## Producing boxplots for different slides.
     plot.scale.box(mouse.lratio$M)
}
\keyword{boxplots, microarray}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
