% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_diversity}
\alias{ts_diversity}
\title{Calculate diversity in given sets of individuals}
\usage{
ts_diversity(
  ts,
  sample_sets,
  mode = c("site", "branch", "node"),
  windows = NULL,
  span_normalise = TRUE
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{sample_sets}{A list (optionally a named list) of character vectors with
individual names (one vector per set). If a simple vector is provided, it
will be interpreted as \code{as.list(sample_sets)}, meaning that a given
statistic will be calculated for each individual separately.}

\item{mode}{The mode for the calculation ("sites" or "branch")}

\item{windows}{Coordinates of breakpoints between windows. The first
coordinate (0) and the last coordinate (equal to \code{ts$sequence_length})
are added automatically)}

\item{span_normalise}{Divide the result by the span of the window? Default
TRUE, see the tskit documentation for more detail.}
}
\value{
For each set of individuals either a single diversity value or a
vector of diversity values (one for each window)
}
\description{
Calculate diversity in given sets of individuals
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model) \%>\% ts_mutate(mutation_rate = 1e-8, random_seed = 42)

# collect sampled individuals from all populations in a list
sample_sets <- ts_samples(ts) \%>\%
  split(., .$pop) \%>\%
  lapply(function(pop) pop$name)

# compute diversity in each population based on sample sets extracted
# in the previous step
ts_diversity(ts, sample_sets) \%>\% .[order(.$diversity), ]
}
