% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_slack_api.R
\name{call_slack_api}
\alias{call_slack_api}
\title{A wrapper function to call the Slack API with authentication and pagination.}
\usage{
call_slack_api(
  path,
  ...,
  body = NULL,
  .method = c("GET", "POST"),
  token,
  .verbose = Sys.getenv("SLACKR_VERBOSE", "FALSE"),
  .next_cursor = ""
)
}
\arguments{
\item{path}{The API definition path, e.g. \verb{/api/auth.test}}

\item{...}{These arguments must be named and will be added to the API query string}

\item{body}{If \code{.method = POST} the \code{body} gets passed to the API body}

\item{.method}{Either "GET" or "POST"}

\item{token}{The Slack bot OAuth token {character vector}}

\item{.verbose}{If TRUE, prints \code{httr} verbose messages.  Useful for debugging.}

\item{.next_cursor}{The value of the next cursor, when using pagination.}
}
\value{
The API response (a named list)
}
\description{
A wrapper function to call the Slack API with authentication and pagination.
}
