% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{spd}
\alias{spd}
\title{Summed probability density (SPD)}
\usage{
spd(pdf, normalise = F, xrange, .cutoff = 1e-05, .res = 0.01)
}
\arguments{
\item{pdf}{A \emph{skyscapeR.pdf} object created with either \code{\link{az.pdf}} or \code{\link{coordtrans}}}

\item{normalise}{(Optional) Boolean to control whether to normalize the SPD. Default is FALSE}

\item{xrange}{(Optional) Array of values (min and max) for SPD if different from range of \emph{pdf}}

\item{.cutoff}{(Optional) Value of SPD at which point it will be cutoff to save on memory. Default is 1e-5}

\item{.res}{(Optional) Resolution with which to output SPD. Default is 0.01 degrees.}
}
\description{
Summed probability density (SPD)
}
\examples{
# SPD of azimuths
Az <- az.pdf(az=c(87,93,90,110), unc=3)
s1 <- spd(Az)
plot(s1)

# SPD of declinations
hor <- createHor(az=c(0,360), alt=c(0,0), loc=c(35,-8,25)) # flat horizon with 0 degrees of altitude
Dec <- coordtrans(Az, hor)
s2 <- spd(Dec)
plot(s2)
}
\references{
Silva, F (2020) A probabilistic framework and significance test for the analysis of structural orientations
 in skyscape archaeology \emph{Journal of Archaeological Science} 118, 105138. <doi:10.1016/j.jas.2020.105138>
}
