% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skylight.R
\name{skylight}
\alias{skylight}
\title{Sky illuminance values for the sun and moon}
\usage{
skylight(.data, longitude, latitude, date, sky_condition = 1)
}
\arguments{
\item{.data}{A data frame or data frame extension (e.g. a tibble) with
named columns: longitude, latitude, date and optionally sky_condition}

\item{longitude}{decimal longitude (single value or vector of values)}

\item{latitude}{decimal latitude (single value or vector of values)}

\item{date}{date and time in POSIXct format with GMT/UTC as time zone
(single value or vector of values)}

\item{sky_condition}{a positive value (>=1) with which to scale
illuminance values (1 = cloud cover < 30%, 2 = thin veiled clouds
3 = average clouds, 10 = dark stratus clouds). By and large this
can be considered a scaling factor, substituting it with the (inverse)
slope parameter of an empirical fit should render more accurate results.
(this can be a single value or vector of values)}
}
\value{
Sun and moon illuminance values (in lux), as well as their respective
location in the sky (altitude, azimuth).
}
\description{
Function returns sky illuminance parameters for
both the sun and the moon, in addition to some
ancillary parameters such as sun and moon azimuth
and altitude.
}
\details{
The code is almost verbatim transcription of the work
"Computer Programs for Sun and Moon Illuminance
With Contingent Tables and Diagrams by Janiczek and DeYoung"
and published in the US Naval observatory circular nr. 171, 1987.

Required parameters are a location (in longitude, latitude),
and a date in POSIXct format set to the GMT/UTC time zone.
Conversions to GMT/UTC should be done externally, errors
are not trapped.

The original code has been vectorized, as such vectors of
location, time and/or sky conditions can be provided.
}
\examples{

 # run the function on standard
 # input variables (single values or vectors of equal size)
 df <- skylight(
  longitude = -135.8,
  latitude = -23.4,
  date = as.POSIXct("1986-12-18 21:00:00", tz = "GMT"),
  sky_condition = 1
 )

 print(df)

 # create data frame of input variables
 input <- data.frame(
   longitude = 0,
   latitude = 50,
   date =  as.POSIXct("2020-06-18 00:00:00", tz = "GMT") + seq(0, 1*24*3600, 1800),
   sky_condition = 1
  )

  # calculate on data frame
  df <- skylight(input)

  print(df)

  # the above statement can also be used
  # in a piped fashion in R >= 4.2
  # input |> skylight()

}
