% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avm.fwls.R
\name{avm.fwls}
\alias{avm.fwls}
\title{Apply Feasible Weighted Least Squares to a Linear Regression Model}
\usage{
avm.fwls(object, fastfit = FALSE)
}
\arguments{
\item{object}{Either an object of class \code{"alvm.fit"} or an object
of class \code{"anlvm.fit"}}

\item{fastfit}{A logical. If \code{FALSE} (the default), the linear
regression model is fit using \code{\link[stats]{lm}}; otherwise,
using \code{\link[stats]{lm.wfit}}}
}
\value{
Either an object of \code{\link[base]{class}} \code{"lm"}
   (if \code{fastfit} is \code{FALSE}) or otherwise a generic
   list object
}
\description{
This function applies feasible weighted least squares (FWLS) to a
   linear regression model using error variance estimates obtained
   from an auxiliary linear variance model fit using \code{alvm.fit}
   or from an auxiliary nonlinear variance model fit using
   \code{anlvm.fit}.
}
\details{
The function simply calculates
   \deqn{\hat{\beta}=(X'\hat{\Omega}^{-1}X)^{-1}X'\hat{\Omega}^{-1}y},
   where \eqn{X} is the design matrix, \eqn{y} is the response vector, and
   \eqn{\hat{\Omega}} is the diagonal variance-covariance matrix of the
   random errors, whose diagonal elements have been estimated by an
   auxiliary variance model.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
myalvm <- alvm.fit(mainlm = mtcars_lm, model = "linear",
   varselect = "qgcv.linear")
myfwls <- avm.fwls(myalvm)
cbind(coef(mtcars_lm), coef(myfwls))

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{alvm.fit}}, \code{\link{anlvm.fit}},
   \code{\link{avm.vcov}}
}
