% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_labels.R
\name{zap_na_tags}
\alias{zap_na_tags}
\title{Convert tagged NA values into regular NA}
\usage{
zap_na_tags(x, ...)
}
\arguments{
\item{x}{A \code{\link[haven]{labelled}} vector with \code{tagged_na}
values, or a data frame with such vectors.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}
}
\value{
\code{x}, where all \code{tagged_na} values are converted to \code{NA}.
}
\description{
Replaces all \code{\link[haven]{tagged_na}} values with
               regular \code{NA}.
}
\examples{
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
x
get_na(x)
zap_na_tags(x)
get_na(zap_na_tags(x))

# also works with non-labelled vector that have tagged NA values
x <- c(1:5, tagged_na("a"), tagged_na("z"), NA)
haven::print_tagged_na(x)
haven::print_tagged_na(zap_na_tags(x))

}
\seealso{
\code{\link{set_na}} and \code{\link{get_na}};
         \code{\link{drop_labels}} to drop labels from zero-count values.
}
