% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\title{Basic descriptive statistics}
\usage{
descr(x, ...)
}
\arguments{
\item{x}{A vector or a data frame. May also be a grouped data frame
(see 'Note' and 'Examples').}

\item{...}{Optional, unquoted names of variables. Required, if \code{x} is
a data frame (and no vector) and only selected variables
from \code{x} should be processed. You may also use functions like
\code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
The latter must be stated as formula (i.e. beginning with \code{~}).
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}
}
\value{
A data frame with basic descriptive statistics, derived from the
        \code{\link[psych]{describe}}-function.
}
\description{
This function wraps the \code{\link[psych]{describe}}-function
             and prints a basic descriptive statistic, including variable labels.
}
\note{
\code{data} may also be a grouped data frame (see \code{\link[dplyr]{group_by}})
      with up to two grouping variables. Descriptive tables are created for each
      subgroup then.
}
\examples{
data(efc)
descr(efc, e17age, c160age)

library(dplyr)
efc \%>\% select(e42dep, e15relat, c172code) \%>\% descr()

# with grouped data frames
efc \%>\%
  group_by(e16sex) \%>\%
  select(e16sex, e42dep, e15relat, c172code) \%>\%
  descr()

efc \%>\%
  group_by(e16sex, c172code) \%>\%
  select(e16sex, c172code, e17age, c160age) \%>\%
  descr()

}
