% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_table.R
\name{flat_table}
\alias{flat_table}
\title{Flat (proportional) tables}
\usage{
flat_table(.data, ..., margin = c("counts", "cell", "row", "col"),
  digits = 2)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{One or more variables of \code{.data} that should be printed as table.}

\item{margin}{Specify the table margin that should be computed for proportional
tables. By default, counts are printed. Use \code{margin = "cell"},
\code{margin = "col"} or \code{margin = "row"} to print cell,
column or row percentages of the table margins.}

\item{digits}{Numeric; for proportional tables, \code{digits} indicates the
number of decimal places.}
}
\value{
An object of class \code{\link[stats]{ftable}}.
}
\description{
This function creates a labelled flat table or flat
             proportional (marginal) table.
}
\examples{
data(efc)

# flat table with counts
flat_table(efc, e42dep, c172code, e16sex)

# flat table with proportions
flat_table(efc, e42dep, c172code, e16sex, margin = "row")

}
\seealso{
\code{\link{frq}} for simple frequency table of labelled vectors.
}

