% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/weight.R
\name{weight}
\alias{weight}
\title{Weight a variable}
\usage{
weight(x, weights, digits = 0)
}
\arguments{
\item{x}{(Unweighted) variable}

\item{weights}{Vector with same length as \code{x}, which
contains weight factors. Each value of \code{x} has a
specific assigned weight in \code{weights}.}

\item{digits}{Numeric value indicating the number of decimal places to be
         used for rounding the weighted values. By default, this value is
         \code{0}, i.e. the returned values are integer values.}
}
\value{
The weighted \code{x}.
}
\description{
This function weights the variable \code{x} by
               a specific vector of \code{weights}.
}
\note{
The values of the returned vector are in sorted order, whereas the values'
       order of the original \code{x} may be spread randomly. Hence, \code{x} can't be
       used, for instance, for further cross tabulation. In case you want to have
       weighted contingency tables or (grouped) box plots etc., use the \code{weightBy}
       argument of most functions.
}
\examples{
v <- sample(1:4, 20, TRUE)
table(v)
w <- abs(rnorm(20))
table(weight(v, w))
}
\seealso{
\code{\link{weight2}}
}

