% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sjSDM}
\alias{plot.sjSDM}
\title{Coefficients plot}
\usage{
\method{plot}{sjSDM}(x, ...)
}
\arguments{
\item{x}{a model fitted by \code{\link{sjSDM}}}

\item{...}{Additional arguments to pass to \code{\link{plotsjSDMcoef}}.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting coefficients returned by sjSDM model.
This function only for model fitted by linear, fitted by DNN is not yet supported.
}
\examples{
\dontrun{
library(sjSDM)
# simulate community:
com = simulate_SDM(env = 6L, species = 7L, sites = 100L)

# fit model:
model = sjSDM(Y = com$response,env = com$env_weights, iter = 2L,se = TRUE) 

#create a group dataframe for plot
species=c("sp1","sp2","sp3","sp4","sp5","sp6","sp7")
group=c("mammal","bird","fish","fish","mammal","amphibian","amphibian")
group = data.frame(species=species,group=group)

plot(model,group=group)
}
}
\seealso{
\code{\link{plotsjSDMcoef}}
}
\author{
CAI Wang
}
