% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabOdds.R
\name{sjt.glmer}
\alias{sjt.glmer}
\title{Summary of generalized linear mixed models as HTML table}
\usage{
sjt.glmer(..., pred.labels = NULL, depvar.labels = NULL,
  remove.estimates = NULL, group.pred = FALSE, exp.coef = TRUE,
  p.numeric = TRUE, emph.p = FALSE, p.zero = FALSE,
  separate.ci.col = TRUE, newline.ci = TRUE, show.ci = TRUE,
  show.se = FALSE, show.header = FALSE, show.col.header = TRUE,
  show.r2 = FALSE, show.icc = TRUE, show.re.var = TRUE,
  show.loglik = FALSE, show.aic = FALSE, show.aicc = FALSE,
  show.dev = TRUE, show.hoslem = FALSE, show.family = FALSE,
  string.pred = "Predictors", string.dv = "Dependent Variables",
  string.interc = "(Intercept)", string.obs = "Observations",
  string.est = NULL, string.ci = "CI", string.se = "std. Error",
  string.p = "p", ci.hyphen = "&nbsp;&ndash;&nbsp;", digits.est = 2,
  digits.p = 3, digits.ci = 2, digits.se = 2, digits.summary = 3,
  cell.spacing = 0.2, cell.gpr.indent = 0.6, sep.column = TRUE,
  CSS = NULL, encoding = NULL, file = NULL, use.viewer = TRUE,
  no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{...}{One or more fitted generalized linear (mixed) models.}

\item{pred.labels}{Character vector with labels of predictor variables.
If not \code{NULL}, \code{pred.labels} will be used in the first
table column with the predictors' names. If \code{NULL}, variable
labels are set based on label attributes (see \code{\link[sjlabelled]{get_label}}).
If \code{pred.labels = ""}, column names (vector names) are used
as predictor labels. See 'Examples'.}

\item{depvar.labels}{Character vector with labels of dependent
variables of all fitted models. See 'Examples'.}

\item{remove.estimates}{Numeric vector with indices (order equals to row index of \code{coef(fit)})
or character vector with coefficient names that indicate which estimates should be removed
from the table output. The first estimate is the intercept, followed by the model predictors.
\emph{The intercept cannot be removed from the table output!} \code{remove.estimates = c(2:4)}
would remove the 2nd to the 4th estimate (1st to 3rd predictor after intercept) from the output.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{group.pred}{Logical, if \code{TRUE} (default), automatically groups table rows with
factor levels of same factor, i.e. predictors of type \code{\link{factor}} will
be grouped, if the factor has more than two levels. Grouping means that a separate headline
row is inserted to the table just before the predictor values.}

\item{exp.coef}{Logical, if \code{TRUE} (default), regression coefficients and
confidence intervals are exponentiated. Use \code{FALSE} for
non-exponentiated coefficients (log-odds) as provided by
the \code{\link{summary}} function.}

\item{p.numeric}{Logical, if \code{TRUE}, the p-values are printed
as numbers. If \code{FALSE} (default), asterisks are used.}

\item{emph.p}{Logical, if \code{TRUE}, significant p-values are shown bold faced.}

\item{p.zero}{logical, if \code{TRUE}, p-values have a leading 0 before the
period (e.g. \emph{0.002}), else p-values start with a period and
without a zero (e.g. \emph{.002}).}

\item{separate.ci.col}{Logical, if \code{TRUE}, the CI values are shown in a separate table column.
Default is \code{FALSE}.}

\item{newline.ci}{Logical, if \code{TRUE} and \code{separate.ci.col = FALSE}, inserts a line break
between estimate and CI values. If \code{FALSE}, CI values are printed in the same
line as estimate values.}

\item{show.ci}{Logical, if \code{TRUE} (default), the confidence intervall is also printed to the table. Use
\code{FALSE} to omit the CI in the table.}

\item{show.se}{Logical, if \code{TRUE}, the standard errors are also printed.
Default is \code{FALSE}.}

\item{show.header}{Logical, if \code{TRUE}, the header strings \code{string.pred}
and \code{string.dv} are shown. By default, they're hidden.}

\item{show.col.header}{Logical, if \code{TRUE} (default), the table data columns have a headline with
abbreviations for estimates, std. beta-values, confidence interval and p-values.}

\item{show.r2}{Logical, if \code{TRUE} (default), the pseudo R2 values for each model are printed
in the model summary. R2cs is the Cox-Snell-pseudo R-squared value, R2n is Nagelkerke's
pseudo R-squared value and \code{D} is Tjur's Coefficient of Discrimination
(see \code{\link[sjstats]{cod}}).}

\item{show.icc}{Logical, if \code{TRUE}, the intra-class-correlation for each
model is printed in the model summary. Only applies to mixed models.}

\item{show.re.var}{Logical, if \code{TRUE}, the variance parameters for the random
effects for each model are printed in the model summary. Only applies to mixed models.
For details output, see 'Note' in \code{\link[sjstats]{icc}}.}

\item{show.loglik}{Logical, if \code{TRUE}, the Log-Likelihood for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{show.aic}{Logical, if \code{TRUE}, the AIC value for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{show.aicc}{Logical, if \code{TRUE}, the second-order AIC value for each model
is printed in the model summary. Default is \code{FALSE}.}

\item{show.dev}{Logical, if \code{TRUE}, the deviance for each model
is printed in the model summary.}

\item{show.hoslem}{Logical, if \code{TRUE}, a Hosmer-Lemeshow-Goodness-of-fit-test is
performed. A well-fitting model shows no significant difference between
the model and the observed data, i.e. the reported p-values should be
greater than 0.05.}

\item{show.family}{Logical, if \code{TRUE}, the family object and link function for each fitted model
are printed. Can be used in case you want to compare models with different link functions
and same predictors and response, to decide which model fits best. See \code{\link{family}}
for more details. It is recommended to inspect the model \code{\link{AIC}} (see \code{show.aic}) to get a
decision help for which model to choose.}

\item{string.pred}{Character vector,used as headline for the predictor column.
Default is \code{"Predictors"}.}

\item{string.dv}{Character vector, used as headline for the
dependent variable columns. Default is \code{"Dependent Variables"}.}

\item{string.interc}{Character vector, used as headline for the Intercept row.
Default is \code{"Intercept"}.}

\item{string.obs}{character vector, used in the summary row for the count of observation
(cases). Default is \code{"Observations"}.}

\item{string.est}{Character vector, used for the column heading of estimates.}

\item{string.ci}{Character vector, used for the column heading of confidence interval values. Default is \code{"CI"}.}

\item{string.se}{Character vector, used for the column heading of standard error values. Default is \code{"std. Error"}.}

\item{string.p}{Character vector, used for the column heading of p values. Default is \code{"p"}.}

\item{ci.hyphen}{Character vector, indicating the hyphen for confidence interval range.
May be an HTML entity. See 'Examples'.}

\item{digits.est}{Amount of decimals for estimates}

\item{digits.p}{Amount of decimals for p-values}

\item{digits.ci}{Amount of decimals for confidence intervals}

\item{digits.se}{Amount of decimals for standard error}

\item{digits.summary}{Amount of decimals for values in model summary}

\item{cell.spacing}{Numeric, inner padding of table cells. By default, this value is 0.2 (unit is cm), which is
suitable for viewing the table. Decrease this value (0.05 to 0.1) if you want to import the table
into Office documents. This is a convenient argument for the \code{CSS} argument for changing
cell spacing, which would be: \code{CSS = list(css.thead = "padding:0.2cm;", css.tdata = "padding:0.2cm;")}.}

\item{cell.gpr.indent}{Indent for table rows with grouped factor predictors. Only applies
if \code{group.pred = TRUE}.}

\item{sep.column}{Logical, if \code{TRUE}, an empty table column is added after
each model column, to add margins between model columns. By default, this
column will be added to the output; however, when copying tables to
office applications, it might be helpful not to add this separator column
when modifying the table layout.}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. For more details,
see \href{../doc/sjtbasic.html}{this package-vignette}, or 'Details' in
\code{\link{sjt.frq}}.}

\item{encoding}{String, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{Logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{Logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Summarizes (multiple) fitted generalized linear mixed models (odds ratios, ci, p-values...)
               as HTML table, or saves them as file. The fitted models may have different predictors,
               e.g. when comparing different stepwise fitted models.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
Computation of p-values (if necessary) is based on normal-distribution
        assumption, treating the t-statistics as Wald z-statistics.
        \cr \cr
        The variance components of the random parts (see \code{show.re.var}) are
        denoted like:
        \itemize{
         \item between-group-variance: tau-zero-zero
         \item random-slope-intercept-correlation: rho-zero-one
         }
      Standard errors for generalized linear (mixed) models are \emph{not}
      the regular standard errors on the untransformed scale, as shown in the
      \code{summary()}-method. Rather, \code{sjt.glmer()} uses adjustments
      according to the delta method for approximating standard errors of
      transformed regression parameters (see \code{\link[sjstats]{se}}).
      \cr \cr Futhermore, see 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
library(lme4)
library(sjmisc)
data(efc)

# create binary response
efc$hi_qol <- dicho(efc$quol_5)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_labels(efc$e15relat)
# data frame for fitted model
mydf <- data.frame(hi_qol = to_factor(efc$hi_qol),
                   sex = to_factor(efc$c161sex),
                   c12hour = efc$c12hour,
                   neg_c_7 = efc$neg_c_7,
                   education = to_factor(efc$c172code),
                   grp = efc$grp)

# fit glmer
fit1 <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + (1|grp),
              data = mydf, family = binomial("logit"))
fit2 <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + education + (1|grp),
              data = mydf, family = binomial("logit"))

# print summary table
sjt.glmer(fit1, fit2, ci.hyphen = " to ")

# print summary table, using different table layout
sjt.glmer(fit1, fit2, show.aic = TRUE, show.ci = FALSE,
          show.se = TRUE, p.numeric = FALSE)

# print summary table
sjt.glmer(fit1, fit2, pred.labels = c("Elder's gender (female)",
            "Hours of care per week", "Negative Impact",
            "Educational level (mid)", "Educational level (high)"))

# use vector names as predictor labels
sjt.glmer(fit1, fit2, pred.labels = "")}


}
