% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabFrequencies.R
\name{sjt.frq}
\alias{sjt.frq}
\title{Summary of frequencies as HTML table}
\usage{
sjt.frq(data, weight.by = NULL, title.wtd.suffix = " (weighted)",
  var.labels = NULL, value.labels = NULL, sort.frq = c("none", "asc",
  "desc"), altr.row.col = FALSE, string.val = "value", string.cnt = "N",
  string.prc = "raw \%", string.vprc = "valid \%",
  string.cprc = "cumulative \%", string.na = "missings", emph.md = FALSE,
  emph.quart = FALSE, show.summary = TRUE, show.skew = FALSE,
  show.kurtosis = FALSE, skip.zero = "auto", ignore.strings = TRUE,
  auto.group = NULL, auto.grp.strings = TRUE, max.string.dist = 3,
  digits = 2, CSS = NULL, encoding = NULL, file = NULL,
  use.viewer = TRUE, no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{data}{variables which frequencies should be printed as table. Either use a single variable
(vector) or a data frame where each column represents a variable (see 'Examples').}

\item{weight.by}{weight factor that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is 
\code{NULL}, so no weights are used.}

\item{title.wtd.suffix}{suffix (as string) for the title, if \code{weight.by} is specified,
e.g. \code{title.wtd.suffix=" (weighted)"}. Default is \code{NULL}, so 
title will not have a suffix when cases are weighted.}

\item{var.labels}{character vector with variable names, which will be used 
to label variables in the output.}

\item{value.labels}{character vector (or \code{list} of character vectors)
with value labels of the supplied variables, which will be used 
to label variable values in the output.}

\item{sort.frq}{Determines whether categories should be sorted 
according to their frequencies or not. Default is \code{"none"}, so 
categories are not sorted by frequency. Use \code{"asc"} or
\code{"desc"} for sorting categories ascending or descending order.}

\item{altr.row.col}{logical, if \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{string.val}{label for the very first table column containing the values (see
\code{value.labels}).}

\item{string.cnt}{label for the first table data column containing the counts. Default is \code{"N"}.}

\item{string.prc}{label for the second table data column containing the raw percentages. Default is \code{"raw \%"}.}

\item{string.vprc}{String label for the third data table column containing the valid percentages, i.e. the
count percentage value exluding possible missing values.}

\item{string.cprc}{String label for the last table data column containing the cumulative percentages.}

\item{string.na}{String label for the last table data row containing missing values.}

\item{emph.md}{If \code{TRUE}, the table row indicating the median value will
be emphasized.}

\item{emph.quart}{If \code{TRUE}, the table row indicating the lower and upper quartiles will
be emphasized.}

\item{show.summary}{If \code{TRUE} (default), a summary row with total and valid N as well as mean and
standard deviation is shown.}

\item{show.skew}{If \code{TRUE}, the variable's skewness is added to the summary.
The skewness is retrieved from the \code{\link[psych]{describe}}-function 
of the \pkg{psych}-package and indicated by a lower case Greek gamma.}

\item{show.kurtosis}{If \code{TRUE}, the variable's kurtosis is added to the summary.
The kurtosis is retrieved from the \code{\link[psych]{describe}}-function 
of the \pkg{psych}-package and indicated by a lower case Greek omega.}

\item{skip.zero}{If \code{TRUE}, rows with only zero-values are not printed
(e.g. if a variable has values or levels 1 to 8, and levels / values 
4 to 6 have no counts, these values would not be printed in the table). 
Use \code{FALSE} to print also zero-values, or use \code{"auto"} (default)
to detect whether it makes sense or not to print zero-values (e.g., a variable
"age" with values from 10 to 100, where at least 25 percent of all possible values have no
counts, zero-values would be skipped automatically).}

\item{ignore.strings}{If \code{TRUE} (default), character vectors / string variables will be removed from
\code{data} before frequency tables are computed.}

\item{auto.group}{numeric value, indicating the minimum amount of unique values 
in the count variable, at which automatic grouping into smaller units 
is done (see \code{\link[sjmisc]{group_var}}). Default value for 
\code{auto.group} is \code{NULL}, i.e. auto-grouping is off.
See \code{\link[sjmisc]{group_var}} for examples on grouping.}

\item{auto.grp.strings}{if \code{TRUE} (default), string values in character 
vectors (string variables) are automatically grouped based on their 
similarity. The similarity is estimated with the \pkg{stringdist}-package.
You can specify a distance-measure via \code{max.string.dist} argument. This argument only
applies if \code{ignore.strings} is \code{FALSE}.}

\item{max.string.dist}{the allowed distance of string values in a character vector, which indicates
when two string values are merged because they are considered as close enough.
See \code{auto.grp.strings}.}

\item{digits}{numeric, amount of digits after decimal point when rounding estimates and values.}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the 
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{encoding}{string, indicating the charset encoding used for variable and 
value labels. Default is \code{NULL}, so encoding will be auto-detected 
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and 
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{If \code{TRUE}, the HTML table is shown in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item each frequency table as web page content (\code{page.content.list}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows (multiple) frequency tables as HTML file, or saves them as file.
}
\details{
\bold{How does the \code{CSS}-argument work?}
           \cr \cr
           With the \code{CSS}-argument, the visual appearance of the tables
           can be modified. To get an overview of all style-sheet-classnames 
           that are used in this function, see return value \code{page.style} for details. 
           Arguments for this list have following syntax:
         \enumerate{
           \item the class-names with \code{"css."}-prefix as argument name and
           \item each style-definition must end with a semicolon
         } 
         You can add style information to the default styles by using a + (plus-sign) as
         initial character for the argument attributes. Examples:
         \itemize{
           \item \code{css.table = 'border:2px solid red;'} for a solid 2-pixel table border in red.
           \item \code{css.summary = 'font-weight:bold;'} for a bold fontweight in the summary row.
           \item \code{css.lasttablerow = 'border-bottom: 1px dotted blue;'} for a blue dotted border of the last table row.
           \item \code{css.colnames = '+color:green'} to add green color formatting to column names.
           \item \code{css.arc = 'color:blue;'} for a blue text color each 2nd row.
           \item \code{css.caption = '+color:red;'} to add red font-color to the default table caption style.
         }
         See further examples at \href{http://www.strengejacke.de/sjPlot/sjtbasics}{sjPlot manual: sjt-basics}.
}
\note{
The HTML tables can either be saved as file and manually opened (specify argument \code{file}) or
        they can be saved as temporary files and will be displayed in the RStudio Viewer pane (if working with RStudio)
        or opened with the default web browser. Displaying resp. opening a temporary file is the
        default behaviour (i.e. \code{file = NULL}).
}
\examples{
\dontrun{
# load sample data
library(sjmisc)
data(efc)

# show frequencies of "e42dep" in RStudio Viewer Pane
# or default web browser
sjt.frq(efc$e42dep)

# plot and show frequency table of "e42dep" with labels
sjt.frq(efc$e42dep, var.labels = "Dependency",
        value.labels = c("independent", "slightly dependent",
                         "moderately dependent", "severely dependent"))

# plot frequencies of e42dep, e16sex and c172code in one HTML file
# and show table in RStudio Viewer Pane or default web browser
# Note that value.labels of multiple variables have to be
# list-objects
sjt.frq(data.frame(efc$e42dep, efc$e16sex, efc$c172code),
        var.labels = c("Dependency", "Gender", "Education"),
        value.labels = list(c("independent", "slightly dependent",
                              "moderately dependent", "severely dependent"),
                            c("male", "female"), c("low", "mid", "high")))

# auto-detection of labels
sjt.frq(data.frame(efc$e42dep, efc$e16sex, efc$c172code))

# plot larger scale including zero-counts
# indicating median and quartiles
sjt.frq(efc$neg_c_7, emph.md = TRUE, emph.quart = TRUE)

# sort frequencies
sjt.frq(efc$e42dep, sort.frq = "desc")

# User defined style sheet
sjt.frq(efc$e42dep,
        CSS = list(css.table = "border: 2px solid;",
                   css.tdata = "border: 1px solid;",
                   css.firsttablecol = "color:#003399; font-weight:bold;"))}

}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjt.frq/}{sjPlot manual: sjt.frq}
           \item \code{\link{sjp.frq}}
         }
}

