% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjTabOdds.R
\name{sjt.glmer}
\alias{sjt.glmer}
\title{Summary of generalized linear mixed models as HTML table}
\usage{
sjt.glmer(..., file = NULL, labelPredictors = NULL,
  labelDependentVariables = NULL, stringPredictors = "Predictors",
  stringDependentVariables = "Dependent Variables",
  showHeaderStrings = FALSE, stringModel = "Model",
  stringIntercept = "(Intercept)", stringObservations = "Observations",
  stringOR = "OR", stringCI = "CI", stringSE = "std. Error",
  stringP = "p", digits.est = 2, digits.p = 3, digits.ci = 2,
  digits.se = 2, digits.summary = 3, exp.coef = TRUE,
  pvaluesAsNumbers = TRUE, boldpvalues = TRUE, showConfInt = TRUE,
  showStdError = FALSE, ci.hyphen = "&nbsp;&ndash;&nbsp;",
  separateConfColumn = TRUE, newLineConf = TRUE, showAbbrHeadline = TRUE,
  showICC = TRUE, showLogLik = FALSE, showAIC = FALSE, showAICc = FALSE,
  showHosLem = FALSE, showFamily = FALSE, remove.estimates = NULL,
  cellSpacing = 0.2, encoding = NULL, CSS = NULL, useViewer = TRUE,
  no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{...}{one or more fitted generalized linear (mixed) models.}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{labelPredictors}{character vector with labels of predictor variables.
If not \code{NULL}, \code{labelPredictors} will be used in the first
table column with the predictors' names. See 'Examples'.}

\item{labelDependentVariables}{character vector with labels of dependent
variables of all fitted models. See 'Examples'.}

\item{stringPredictors}{string constant used as headline for the predictor column.
Default is \code{"Predictors"}.}

\item{stringDependentVariables}{string constant used as headline for the
dependent variable columns. Default is \code{"Dependent Variables"}.}

\item{showHeaderStrings}{logical, if \code{TRUE}, the header strings \code{stringPredictors}
and \code{stringDependentVariables} are shown. By default, they're hidden.}

\item{stringModel}{string constant used as headline for the model names in case no
labels for the dependent variables are provided (see \code{labelDependentVariables}).
Default is \code{"Model"}.}

\item{stringIntercept}{string constant used as headline for the Intercept row.
Default is \code{"Intercept"}.}

\item{stringObservations}{string constant used in the summary row for the count of observation
(cases). Default is \code{"Observations"}.}

\item{stringOR}{string used for the column heading of odds ratio values. Default is \code{"OR"}.}

\item{stringCI}{string used for the column heading of confidence interval values. Default is \code{"CI"}.}

\item{stringSE}{string used for the column heading of standard error values. Default is \code{"std. Error"}.}

\item{stringP}{string used for the column heading of p values. Default is \code{"p"}.}

\item{digits.est}{amount of decimals for estimates}

\item{digits.p}{amount of decimals for p-values}

\item{digits.ci}{amount of decimals for confidence intervals}

\item{digits.se}{amount of decimals for standard error}

\item{digits.summary}{amount of decimals for values in model summary}

\item{exp.coef}{logical, if \code{TRUE} (default), regression coefficients and
confidence intervals are exponentiated. Use \code{FALSE} for
non-exponentiated coefficients (log-odds) as provided by
the \code{\link{summary}} function.}

\item{pvaluesAsNumbers}{logical, if \code{TRUE}, p-values are shown as numbers. If \code{FALSE} (default),
p-values are indicated by asterisks.}

\item{boldpvalues}{logical, if \code{TRUE} (default), significant p-values are shown bold faced.}

\item{showConfInt}{logical, if \code{TRUE} (default), the confidence intervall is also printed to the table. Use
\code{FALSE} to omit the CI in the table.}

\item{showStdError}{logical, if \code{TRUE}, the standard errors are also printed.
Default is \code{FALSE}.}

\item{ci.hyphen}{string, indicating the hyphen for confidence interval range.
May be an HTML entity. See 'Examples'.}

\item{separateConfColumn}{if \code{TRUE}, the CI values are shown in a separate table column.
Default is \code{FALSE}.}

\item{newLineConf}{logical, if \code{TRUE} and \code{separateConfColumn = FALSE}, inserts a line break
between OR and CI values. If \code{FALSE}, CI values are printed in the same
line with OR values.}

\item{showAbbrHeadline}{logical, if \code{TRUE} (default), the table data columns have a headline with
abbreviations for odds ratios, confidence interval and p-values.}

\item{showICC}{logical, if \code{TRUE}, the intra-class-correlation for each
model is printed in the model summary.}

\item{showLogLik}{logical, if \code{TRUE}, the Log-Likelihood for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{showAIC}{logical, if \code{TRUE}, the AIC value for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{showAICc}{logical, if \code{TRUE}, the second-order AIC value for each model
is printed in the model summary. Default is \code{FALSE}.}

\item{showHosLem}{logical, if \code{TRUE}, a Hosmer-Lemeshow-Goodness-of-fit-test is
performed. A well-fitting model shows no significant difference between
the model and the observed data, i.e. the reported p-values should be
greater than 0.05.}

\item{showFamily}{logical, if \code{TRUE}, the family object and link function for each fitted model
         are printed. Can be used in case you want to compare models with different link functions
         and same predictors and response, to decide which model fits best. See \code{\link{family}}
         for more details. It is recommended to inspect the model \code{\link{AIC}} (see \code{showAIC}) to get a
         decision help for which model to choose.}

\item{remove.estimates}{numeric vector with indices (order equals to row index of \code{coef(fit)})
or character vector with coefficient names that indicate which estimates should be removed
from the table output. The first estimate is the intercept, followed by the model predictors.
\emph{The intercept cannot be removed from the table output!} \code{remove.estimates = c(2:4)}
would remove the 2nd to the 4th estimate (1st to 3rd predictor after intercept) from the output.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{cellSpacing}{numeric, inner padding of table cells. By default, this value is 0.2 (unit is cm), which is
suitable for viewing the table. Decrease this value (0.05 to 0.1) if you want to import the table
into Office documents. This is a convenient argument for the \code{CSS} argument for changing
cell spacing, which would be: \code{CSS = list(css.thead = "padding:0.2cm;", css.tdata = "padding:0.2cm;")}.}

\item{encoding}{string, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Summarizes (multiple) fitted generalized linear mixed models (odds ratios, ci, p-values...)
               as HTML table, or saves them as file. The fitted models may have different predictors,
               e.g. when comparing different stepwise fitted models.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
library(lme4)
library(sjmisc)
data(efc)

# create binary response
efc$hi_qol <- dicho(efc$quol_5)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_labels(efc$e15relat)
# data frame for fitted model
mydf <- data.frame(hi_qol = as.factor(efc$hi_qol),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   neg_c_7 = as.numeric(efc$neg_c_7),
                   education = as.factor(efc$c172code),
                   grp = efc$grp)

# fit glmer
fit1 <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + (1|grp),
              data = mydf,
              family = binomial("logit"))
fit2 <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + education + (1|grp),
              data = mydf,
              family = binomial("logit"))

# print summary table
sjt.glmer(fit1, fit2,
          ci.hyphen = " to ")

# print summary table, using different table layout
sjt.glmer(fit1, fit2,
          showAIC = TRUE,
          showConfInt = FALSE,
          showStdError = TRUE,
          pvaluesAsNumbers = FALSE)

# print summary table
sjt.glmer(fit1, fit2,
          labelPredictors = c("Elder's gender (female)",
                              "Hours of care per week",
                              "Negative Impact",
                              "Educational level (mid)",
                              "Educational level (high)"))}
}

