% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjPlotGLME.R
\name{sjp.glmer}
\alias{sjp.glmer}
\title{Plot odds ratios (forest plots) of generalized linear mixed effects models}
\usage{
sjp.glmer(fit, type = "re", vars = NULL, ri.nr = 1, title = NULL,
  geom.size = 3, geom.colors = "Set1", hideErrorBars = FALSE,
  showIntercept = TRUE, stringIntercept = "(Intercept)", sort.coef = NULL,
  pred.labels = NULL, axisTitle.x = NULL, axisTitle.y = NULL,
  facet.grid = TRUE, free.scale = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", showValueLabels = TRUE, labelDigits = 2,
  showPValueLabels = TRUE, fade.ns = FALSE, show.se = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{fit}{a fitted \code{glmer} object.}

\item{type}{type of plot. Use one of following:
\itemize{
  \item \code{"re"} (default) for odds ratios of random effects
  \item \code{"fe"} for odds ratios of fixed effects
  \item \code{"fe.cor"} for correlation matrix of fixed effects
  \item \code{"re.qq"} for a QQ-plot of random effects (random effects quantiles against standard normal quantiles)
  \item \code{"fe.pc"} or \code{"fe.prob"} to plot probability curves (predicted probabilities) of all fixed effects coefficients. Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot.
  \item \code{"ri.pc"} or \code{"ri.prob"} to plot probability curves (predicted probabilities) of random intercept variances for all fixed effects coefficients. Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot.
}}

\item{vars}{a numeric vector with column indices of selected variables or a character vector with
variable names of selected variables from the fitted model, which should be used to plot probability
curves. This parameter only applies if \code{type} is either \code{"fe.pc"} (resp. \code{"fe.prob"})
or \code{"fe.pc"} (resp. \code{"re.pc"}). In this case, only probability curves (predicted probabilities) for the selected
variables specified in \code{"vars"} will be plotted.}

\item{ri.nr}{Numeric value. If \code{type = "re"} and fitted model has more than one random
intercept, \code{ri.nr} indicates which random effects of which random intercept (or:
which list element of \code{lme4::ranef}) will be plotted. Default is \code{1},
so the first (or only) random intercept will be plotted.}

\item{title}{a character vector with one or more labels that are used as plot title. If
\code{type = "re"}, use the predictors' variable labels as titles.}

\item{geom.size}{size of geoms (point size).}

\item{geom.colors}{User defined color palette for geoms. Must either be vector with two color values
or a specific color palette code (see below).
\itemize{
  \item If not specified, the diverging \code{"Set1"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00")}).}

\item{hideErrorBars}{If \code{TRUE}, the error bars that indicate the confidence intervals of the odds ratios are not
shown.}

\item{showIntercept}{if \code{TRUE}, the intercept is included when plotting random or fixed effects.}

\item{stringIntercept}{string of intercept estimate on the y axis. Only applies, if \code{showIntercept}
is \code{TRUE} and \code{pred.labels} is not \code{NULL}.}

\item{sort.coef}{indicates which coefficient should be used for sorting odds ratios
\itemize{
  \item If \code{NULL} (default), no sorting is done and odds ratios are sorted in order of model coefficients.
  \item If \code{sort.coef = "sort.all"}, odds ratios are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{facet.grid = FALSE}), i.e. the odds ratios of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "fe"}, \code{TRUE} value will sort the odds ratios
  \item Else, specify a predictor's / coefficient's name to sort odds ratios according to this coefficient.
  }
  See examples for details.}

\item{pred.labels}{a character vector with labels for the predictors / covariates / groups. Should either be vector
of fixed effects variable labels (if \code{type = "fe"}) or a vector of group (value)
labels from the random intercept's categories (if \code{type = "re"}).}

\item{axisTitle.x}{A label (title) for the x axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{axisTitle.y}{A label (title) for the y axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{facet.grid}{\code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph.}

\item{free.scale}{If \code{TRUE} and \code{facet.grid=TRUE}, each facet grid gets its own fitted scale. If
\code{free.scale=FALSE}, each facet in the grid has the same scale range.}

\item{interceptLineType}{The linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{The color of the intercept line. Default value is \code{"grey70"}.}

\item{showValueLabels}{Whether odds ratio values should be plotted to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not.}

\item{fade.ns}{if \code{TRUE}, non significant odds ratios will be printed in slightly fading colors.}

\item{show.se}{Use \code{TRUE} to plot (depending on \code{type}) the standard
error for probability curves (predicted probabilities).}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns
         \itemize{
           \item the ggplot-object (\code{plot}), if \code{type = "fe"} or if \code{type = "re"} and \code{facet.grid = TRUE}). Multiple plots (\code{type = "re"} and if \code{facet.grid = FALSE}) are returned in the object \code{plot.list}.
           \item a list of ggplot-objects (\code{plot.list}). see \code{plot} for details.
           \item a data frame \code{mydf} with the data used to build the ggplot-object(s).
           }
}
\description{
Plot odds ratios (exponentiated coefficients) with confidence intervalls of either
               fixed effects or random effects of generalized linear mixed effects models
               (that have been fitted with \code{glmer} of the
               \code{lme4} package.
}
\note{
Thanks to Robert Reijntjes from Leiden University Medical Center for sharing
        R code that is used to compute fixed effects correlation matrices and
        qq-plots of random effects.
}
\examples{
\dontrun{
library(lme4)
# create binary response
sleepstudy$Reaction.dicho <- sju.dicho(sleepstudy$Reaction, dichBy = "md")
# fit model
fit <- glmer(Reaction.dicho ~ Days + (Days | Subject),
             sleepstudy,
             family = binomial("logit"))

# simple plot
sjp.glmer(fit)

# sort by predictor Days
sjp.glmer(fit, sort.coef = "Days")

# plot each predictor as own plot and sort them
sjp.glmer(fit,
          facet.grid = FALSE,
          sort.coef = "sort.all")

library(lme4)
data(efc)
# create binary response
efc$hi_qol <- sju.dicho(efc$quol_5)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- sji.getValueLabels(efc$e15relat)
# data frame for fitted model
mydf <- na.omit(data.frame(hi_qol = as.factor(efc$hi_qol),
                           sex = as.factor(efc$c161sex),
                           c12hour = as.numeric(efc$c12hour),
                           neg_c_7 = as.numeric(efc$neg_c_7),
                           grp = efc$grp))
# fit glmer
fit <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + (1|grp),
             data = mydf,
             family = binomial("logit"))

# plot random effects
sjp.glmer(fit)

# plot fixed effects
sjp.glmer(fit, type = "fe")

# plot and sort fixed effects
sjp.glmer(fit,
          type = "fe",
          sort.coef = TRUE)

# plot fixed effects correlations
sjp.glmer(fit, type = "fe.cor")

# qq-plot of random effects
sjp.glmer(fit, type = "re.qq")

# plot probability curves (predicted probabilities)
# for each covariate, grouped by random intercepts
sjp.glmer(fit,
          type = "ri.pc",
          show.se = TRUE)

# plot probability curves (predicted probabilities)
# for each covariate, grouped by random intercepts
# in integrated plots
sjp.glmer(fit,
          type = "ri.pc",
          facet.grid = FALSE)

# plot probability curve (predicted probabilities)
# of fixed effect, only for coefficient "neg_c_7"
sjp.glmer(fit,
          type = "fe.pc",
          vars = "neg_c_7")}
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.glmer/}{sjPlot manual: sjp.glmer}
           \item \code{\link{sjp.lmer}}
           \item \code{\link{sjp.glm}}
           \item \code{\link{sjp.glmm}}
           \item \code{\link{sjt.glm}}
         }
}

