% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.class_cube}
\alias{plot.class_cube}
\title{Plot classified images}
\usage{
\method{plot}{class_cube}(
  x,
  y,
  ...,
  tile = x[["tile"]][[1]],
  roi = NULL,
  title = "Classified Image",
  legend = NULL,
  palette = "Spectral",
  scale = 1,
  max_cog_size = 1024,
  legend_position = "inside"
)
}
\arguments{
\item{x}{Object of class "class_cube".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{roi}{Spatial extent to plot in WGS 84 - named vector
with either (lon_min, lon_max, lat_min, lat_max) or
(xmin, xmax, ymin, ymax)}

\item{title}{Title of the plot.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{Alternative RColorBrewer palette}

\item{scale}{Relative scale (0.4 to 1.0) of plot text}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "outside")}
}
\value{
A  color map, where each pixel has the color
                        associated to a label, as defined by the legend
                        parameter.
}
\description{
plots a classified raster using ggplot.
}
\note{
The following optional parameters are available to allow for detailed
      control over the plot output:
\itemize{
\item \code{graticules_labels_size}: size of coordinates labels (default = 0.8)
\item \code{legend_title_size}: relative size of legend title (default = 1.0)
\item \code{legend_text_size}: relative size of legend text (default = 1.0)
\item \code{legend_bg_color}: color of legend background (default = "white")
\item \code{legend_bg_alpha}: legend opacity (default = 0.5)
}
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label cube with the most likely class
    label_cube <- sits_label_classification(
        probs_cube,
        output_dir = tempdir()
    )
    # plot the resulting classified image
    plot(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
