% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/who06.R
\docType{data}
\name{who06}
\alias{who06}
\title{The WHO 2006 growth standard}
\format{A data frame with 150 observations on the following 23 variables:
\describe{ \item{years}{age from 0 to 5 years}
\item{L.ht}{numeric vector}
\item{M.ht}{numeric vector}
\item{S.ht}{numeric vector}
\item{L.wt}{numeric vector}
\item{M.wt}{numeric vector}
\item{S.wt}{numeric vector}
\item{L.bmi}{numeric vector}
\item{M.bmi}{numeric vector}
\item{S.bmi}{numeric vector}
\item{L.head}{numeric vector}
\item{M.head}{numeric vector}
\item{S.head}{numeric vector}
\item{L.arm}{numeric vector}
\item{M.arm}{numeric vector}
\item{S.arm}{numeric vector}
\item{L.subscap}{numeric vector}
\item{M.subscap}{numeric vector}
\item{S.subscap}{numeric vector}
\item{L.tricep}{numeric vector}
\item{M.tricep}{numeric vector}
\item{S.tricep}{numeric vector}
\item{sex}{two-level factor with level 1 male and level 2 female} }}
\source{
\url{http://www.who.int/childgrowth/en/}
}
\usage{
who06
}
\description{
The WHO growth standard (WHO 2006) for height, weight, body mass index,
circumferences and skinfold thicknesses, fitted by the LMS method and
summarised by values of L, M and S by sex from birth to 5 years.
}
\details{
The L, M and S values for each measurement correspond respectively to the
Box-Cox power, median and coefficient of variation of the distribution by
age and sex (Cole & Green 1992). The short names for each measurement (see
\code{\link{LMS2z}}) are as follows: height (ht), weight (wt), body mass
index (bmi), head circumference (head), arm circumference (arm), subscapular
skinfold (subscap), and tricep skinfold (tricep).
}
\examples{
data(who06)
## calculate z-score for length 60 cm in boys at age 0:12 months
LMS2z(x = 0:12/12, y = 60, sex = 1, measure = 'ht', ref = 'who06')
}
\references{
World Health Organization. WHO Child Growth Standards: Methods
and development: Length/height-for-age, weight-for-age, weight-for-length,
weight-for-height and body mass index-for-age. Geneva: WHO; 2006.

Cole TJ, Green PJ. Smoothing reference centile curves: the LMS method and
penalized likelihood. Stat Med 1992;11:1305-19.
}
\keyword{datasets}

