\name{person.parameter.rasch.copula}
\alias{person.parameter.rasch.copula}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Person Parameter Estimation of the Rasch Copula Model (Braeken, 2011)
}
\description{
Ability estimates are provided by the Rasch copula model.
}
\usage{
person.parameter.rasch.copula(raschcopula.object, numdiff.parm = 0.001, 
    conv.parm = 0.001, maxiter = 20, stepwidth = 1, 
    print.summary = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{raschcopula.object}{
Object which is generated by the code{rasch.copula2} function.
}
  \item{numdiff.parm}{
Parameter \eqn{h} for numerical differentiation
}
  \item{conv.parm}{
Convergence criterion
}
  \item{maxiter}{
Maximum number of iterations
}
  \item{stepwidth}{
Maximal increment in iterations
}
  \item{print.summary}{
Print summary?
}
  \item{\dots}{
Further arguments to be passed
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
A list with following entries
\item{person}{Estimated person parameters}
\item{se.inflat}{Inflation of individual standard errors due
to local dependence}
\item{theta.table}{Ability estimates for each unique response pattern}
\item{pattern.in.data}{Item response pattern}
\item{summary.theta.table}{Summary statistics of person parameter estimates}
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Alexander Robitzsch
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
See \code{\link{rasch.copula2}} for estimating Rasch copula models.
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
############################################################
# EXAMPLE 1: Reading Data
############################################################

data(data.read)
dat <- data.read

# define item cluster
itemcluster <- rep( 1:3 , each = 4 )
mod1 <- rasch.copula2( dat , itemcluster = itemcluster )
summary(mod1)

# person parameter estimation under the Rasch copula model
pmod1 <- person.parameter.rasch.copula(raschcopula.object = mod1 )
## Mean percentage standard error inflation
##   missing.pattern Mperc.seinflat
## 1               1           6.35

\dontrun{
############################################################
# SIMULATED EXAMPLE 2:
# 12 Items: Cluster 1 -> Items 1,...,4
#           Cluster 2 -> Items 6,...,9
#           Cluster 3 -> Items 10,11,12
############################################################

set.seed(967)
I <- 12                             # number of items
n <- 450                            # number of persons
b <- seq(-2,2, len=I)               # item difficulties
b <- sample(b)                      # sample item difficulties
theta <- rnorm( n , sd = 1 )        # person abilities
# itemcluster
itemcluster <- rep(0,I)
itemcluster[ 1:4 ] <- 1
itemcluster[ 6:9 ] <- 2
itemcluster[ 10:12 ] <- 3
# residual correlations
rho <- c( .35 , .25 , .30 )

# simulate data
dat <- sim.rasch.dep( theta , b , itemcluster , rho )
colnames(dat) <- paste("I" , seq(1,ncol(dat)) , sep="")

# estimate Rasch copula model 
mod1 <- rasch.copula2( dat , itemcluster = itemcluster )
summary(mod1)

# person parameter estimation under the Rasch copula model
pmod1 <- person.parameter.rasch.copula(raschcopula.object = mod1 )
## Mean percentage standard error inflation
##   missing.pattern Mperc.seinflat
## 1               1          10.48 }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{IRT copula models}
\keyword{Person parameter estimation}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
