% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{.cross_check_sim_input}
\alias{.cross_check_sim_input}
\title{Cross check the onset-to-hospitalisation or -death arguments are
compatible with hospitalisation and death risks}
\usage{
.cross_check_sim_input(
  onset_to_hosp,
  onset_to_death,
  hosp_risk,
  hosp_death_risk,
  non_hosp_death_risk
)
}
\arguments{
\item{onset_to_hosp}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-hospitalisation delay distribution. \code{onset_to_hosp} can also be
set to \code{NULL} to not simulate hospitalisation (admission) dates.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-hospitalisation delay. The
function must have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 1.5} and \code{sdlog = 0.5}.

If \code{onset_to_hosp} is set to \code{NULL} then \code{hosp_risk} and \code{hosp_death_risk}
will be automatically set to \code{NULL} if not manually specified.}

\item{onset_to_death}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-death delay distribution. \code{onset_to_death} can also be set to
\code{NULL} to not simulate dates for individuals that died.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-death delay. The function must
have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 2.5} and \code{sdlog = 0.5}.

If \code{onset_to_death} is set to \code{NULL} then \code{non_hosp_death_risk} and
\code{hosp_death_risk} will be automatically set to \code{NULL} if not manually
specified.}

\item{hosp_risk}{Either a single \code{numeric} for the hospitalisation risk of
everyone in the population, or a \verb{<data.frame>} with age specific
hospitalisation risks. Default is 20\% hospitalisation (\code{0.2}) for the entire
population. If the \code{onset_to_hosp} argument is set to \code{NULL} this argument
will automatically be set to \code{NULL} if not specified or can be manually
set to \code{NULL}. See details and examples for more information.}

\item{hosp_death_risk}{Either a single \code{numeric} for the death risk for
hospitalised individuals across the population, or a \verb{<data.frame>} with age
specific hospitalised death risks Default is 50\% death risk in hospitals
(\code{0.5}) for the entire population. If the \code{onset_to_death} argument is set
to \code{NULL} this argument will automatically be set to \code{NULL} if not specified
or can be manually set to \code{NULL}. See details and examples for more
information. The \code{hosp_death_risk} can vary through time if specified in
the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}

\item{non_hosp_death_risk}{Either a single \code{numeric} for the death risk for
outside of hospitals across the population, or a \verb{<data.frame>} with age
specific death risks outside of hospitals. Default is 5\% death risk outside
of hospitals  (\code{0.05}) for the entire population. If the \code{onset_to_death}
argument is set to \code{NULL} this argument will automatically be set to \code{NULL}
if not specified or can be manually set to \code{NULL}. See details and examples
for more information. The \code{non_hosp_death_risk} can vary through time if
specified in the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}
}
\value{
Invisibly return the \code{onset_to_hosp} argument. The function is
called for its side-effects, which will error or warn if the input is
invalid.
}
\description{
There are two types of cross-checking:
\enumerate{
\item If the onset-to-event distribution is specified but the corresponding risk
is not specified (i.e. \code{NULL}) the function will error (\code{\link[=stop]{stop()}}).
\item If the onset-to-event distribution is not specified (i.e. \code{NULL}) but the
corresponding risk is specified the function will throw a warning
(\code{\link[=warning]{warning()}}).
}

The difference in condition handling is because in the case that the
onset-to-event is \code{NULL} the simulation can safely ignore the corresponding
risk, while throwing a warning, as there are no events. In other words, if
the onset-to-hospitalisation is not specified, no infected individuals will
go to hospital and the \code{date_admission} column in the line list will all be
\code{NA}s. However, if the onset-to-event is specified and the corresponding
risk is \code{NULL} then the proportion of individuals infected that are
hospitalised or die cannot be calculated and therefore the simulation
cannot run. It is in this latter case that the cross-checking throws an
error.
}
\keyword{internal}
