% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_2nd_ma1}
\alias{deriv_2nd_ma1}
\title{Analytic second derivative for MA(1) process}
\usage{
deriv_2nd_ma1(theta, sigma2, tau)
}
\arguments{
\item{theta}{A \code{double} corresponding to the theta coefficient of an MA(1) process.}

\item{sigma2}{A \code{double} corresponding to the error term of an MA(1) process.}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing the second partial derivative with respect to \eqn{\theta}{theta},
 the second column contains the partial derivative with respect to \eqn{\theta}{theta} and \eqn{\sigma ^2}{sigma^2},
 and lastly we have the second partial derivative with respect to \eqn{\sigma ^2}{sigma^2}.
}
\description{
To ease a later calculation, we place the result into a matrix structure.
}
\section{Process Haar WV Second Derivative}{

Taking the second derivative with respect to \eqn{\theta}{theta} yields:
\deqn{\frac{{{\partial ^2}}}{{\partial {\theta ^2}}}\nu _j^2\left( {\theta ,{\sigma ^2}} \right) = \frac{{2{\sigma ^2}}}{{{\tau _j}}}}{d^2/dtheta^2 nu[j]^2 (theta, sigma2) = (2*sigma2)/tau[j]}

Taking the second derivative with respect to \eqn{\sigma^2}{sigma^2} yields:
\deqn{\frac{{{\partial ^2}}}{{\partial {\sigma ^4}}}\nu _j^2\left( {\theta ,{\sigma ^2}} \right) = 0}{d^2/dsigma2^2 nu[j]^2 (theta, sigma2) = 0}

Taking the first derivative with respect to \eqn{\theta}{theta} and \eqn{\sigma^2}{sigma^2} yields:
\deqn{\frac{\partial }{{\partial \theta }}\frac{\partial }{{\partial {\sigma ^2}}}\nu _j^2\left( {\theta ,{\sigma ^2}} \right) = \frac{{2(\theta  + 1){\tau _j} - 6}}{{\tau _j^2}}}{d/dtheta * d/dsigma2 nu[j]^2 (theta, sigma2) = (-6 + 2*(1 + theta)*tau[j])/tau[j]^2}
}

\author{
James Joseph Balamuta (JJB)
}
