% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milestone.R
\name{milestone}
\alias{milestone}
\title{Milestone test for two survival curves}
\usage{
milestone(data, ms_time, test_type = c("log-log", "naive"))
}
\arguments{
\item{data}{Data frame containing at least 3 columns:
\itemize{
\item \code{tte} - Time to event.
\item \code{event} - Event indicator.
\item \code{treatment} - Grouping variable.
}}

\item{ms_time}{Milestone analysis time.}

\item{test_type}{Method to build the test statistics.
There are 2 options:
\itemize{
\item \code{"native"}: a native approach by dividing the KM survival difference by its standard derivations,
see equation (1) of Klein, J. P., Logan, B., Harhoff, M., & Andersen, P. K. (2007).
\item \code{"log-log"}: a log-log transformation of the survival, see equation (3) of
Klein, J. P., Logan, B., Harhoff, M., & Andersen, P. K. (2007).
}}
}
\value{
A list frame containing:
\itemize{
\item \code{method} - The method, always \code{"milestone"}.
\item \code{parameter} - Milestone time point.
\item \code{estimate} - Survival difference between the experimental and control arm.
\item \code{se} - Standard error of the control and experimental arm.
\item \code{z} - Test statistics.
}
}
\description{
Milestone test for two survival curves
}
\examples{
cut_data <- sim_pw_surv(n = 200) |>
  cut_data_by_event(150)

cut_data |>
  milestone(10, test_type = "log-log")

cut_data |>
  milestone(10, test_type = "naive")
}
\references{
Klein, J. P., Logan, B., Harhoff, M., & Andersen, P. K. (2007).
"Analyzing survival curves at a fixed point in time."
\emph{Statistics in Medicine}, 26(24), 4505--4519.
}
