% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{genCatFormula}
\alias{genCatFormula}
\title{Generate Categorical Formula}
\usage{
genCatFormula(..., n = 0)
}
\arguments{
\item{...}{one or more numeric values to be concatenated, delimited by ";".}

\item{n}{Number of probabilities (categories) to be generated - all with
equal probability.}
}
\value{
string with multinomial probabilities.
}
\description{
Create a semi-colon delimited string of probabilities to be used
to define categorical data.
}
\details{
The function accepts a number of probabilities or a value of n, but
not both.

If probabilities are passed, the string that is returned depends on the
nature of those probabilities. If the sum of the probabilities is less than
1, an additional category is created with the probability 1 - sum(provided
probabilities). If the sum of the probabilities is equal to 1, then the
number of categories is set to the number of probabilities provided. If the
sum of the probabilities exceeds one (and there is more than one
probability), the probabilities are standardized by dividing by the sum of
the probabilities provided.

If n is provided, n probabilities are included in the string, each with a probability equal to 1/n.
}
\examples{
genCatFormula(0.25, 0.25, 0.50)
genCatFormula(1 / 3, 1 / 2)
genCatFormula(1, 2, 3)
genCatFormula(n = 5)
}
\concept{utility}
