% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_pointrange.R
\name{gg_pointrange}
\alias{gg_pointrange}
\title{Pointrange ggplot.}
\usage{
gg_pointrange(
  data,
  x_var,
  y_var,
  ymin_var,
  ymax_var,
  text_var = NULL,
  pal = pal_viridis_mix(1),
  alpha_line = 1,
  alpha_point = 1,
  size_point = 1.5,
  size_line = 0.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_zero_mid = FALSE,
  x_breaks_n = 5,
  x_expand = NULL,
  x_labels = NULL,
  x_na_rm = FALSE,
  x_rev = FALSE,
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_zero_mid = FALSE,
  y_breaks_n = 5,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_na_rm = FALSE,
  y_title = NULL,
  y_title_wrap = 50,
  y_zero = FALSE,
  y_zero_line = NULL,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(y_grid = TRUE),
  mobile = FALSE
)
}
\arguments{
\item{data}{A data frame in a structure to be plotted untransformed. Required input.}

\item{x_var}{Unquoted variable to be on the x scale (i.e. character, factor, logical, numeric, date or datetime). Required input.}

\item{y_var}{Unquoted numeric variable for the point on the y scale. Required input.}

\item{ymin_var}{Unquoted numeric variable to be the minimum of the y vertical line. Required input.}

\item{ymax_var}{Unquoted numeric variable to be the maximum of the y vertical line. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes.}

\item{alpha_line}{The opacity of the line. Defaults to 1.}

\item{alpha_point}{The opacity of the points.}

\item{size_point}{Size of points. Defaults to 1.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{x_zero_mid}{For a numeric x variable, add balance to the x scale so that zero is in the centre. Defaults to FALSE.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_na_rm}{TRUE or FALSE of whether to include x_var NA values. Defaults to FALSE.}

\item{x_rev}{For a categorical x variable, TRUE or FALSE of whether the x variable variable is reversed. Defaults to FALSE.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE of whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_zero_mid}{For a numeric y variable, add balance to the y scale so that zero is in the centre of the y scale.}

\item{y_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_na_rm}{TRUE or FALSE of whether to include y_var NA values. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to "".}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Pointrange ggplot that is not coloured and not facetted.
}
\examples{
library(dplyr)
library(simplevis)
library(palmerpenguins)

plot_data <- penguins \%>\%
  group_by(sex) \%>\%
  summarise(middle = median(body_mass_g, na.rm = TRUE), 
            lower = quantile(body_mass_g, probs = 0.25, na.rm = TRUE), 
            upper = quantile(body_mass_g, probs = 0.75, na.rm = TRUE))

gg_pointrange(
  plot_data,
  x_var = sex,
  y_var = middle,
  ymin_var = lower,
  ymax_var = upper,
  y_title = "Body mass g")

}
