% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-train.R
\name{train_nn}
\alias{train_nn}
\title{Train Network}
\usage{
train_nn(
  train_data,
  train_target,
  validate_data,
  validate_target,
  model,
  alpha,
  epochs,
  batch_size = nrow(train_data),
  plot_acc = TRUE
)
}
\arguments{
\item{train_data}{set of training data}

\item{train_target}{set of training data targets in one-hot encoded form}

\item{validate_data}{set of validation data targets in one-hot encoded form}

\item{validate_target}{set of targets in}

\item{model}{list of weights and biases}

\item{alpha}{learning rate}

\item{epochs}{number of epochs}

\item{batch_size}{mini-batch size}

\item{plot_acc}{whether or not to plot training and validation accuracy}
}
\value{
list of weights and biases after training
}
\description{
Train the network with specified hyperparameters and return the trained
model.
}
\examples{
\dontrun{
mlp_model <- init_nn(784, 100, 50, 10)
mnist <- load_mnist()
train_data <- mnist[1]
train_target <- mnist[2]
validate_data <- mnist[3]
validate_target <- mnist[4]
mlp_model <- train_nn(train_data, train_target, validate_data,
validate_target, mlp_model, 0.01, 1, 64)
}
}
