% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_absolute.R
\name{calc_absolute}
\alias{calc_absolute}
\title{Calculate absolute performance criteria and MCSE}
\usage{
calc_absolute(
  data,
  estimates,
  true_param,
  criteria = c("bias", "variance", "mse", "rmse")
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{estimates}{Vector or name of column from \code{data} containing point estimates.}

\item{true_param}{Vector or name of column from \code{data} containing corresponding true parameters.}

\item{criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates absolute bias, variance, mean squared error (mse)
and root mean squared error (rmse). The function also calculates the associated
Monte Carlo standard errors.
}
\examples{
calc_absolute(data = t_res, estimates = est, true_param = true_param)

}
