% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_single_fin_statement.R
\name{simfinR_get_single_fin_statement}
\alias{simfinR_get_single_fin_statement}
\title{Fetch financial data for a single company}
\usage{
simfinR_get_single_fin_statement(
  id_sim,
  type_statement,
  period_in,
  year,
  api_key,
  cache_folder
)
}
\arguments{
\item{id_sim}{Simfin id of a company (single value)}

\item{type_statement}{Type of financial statements ('pl' - profit loss, 'bs' - balance sheet, 'cf' - cashflow)}

\item{period_in}{Time periods to grab the data: 'FY' - fiscal year (only for 'pl' and 'cf', use 'Q4' for end of year 'bs'),
'Q1' - first quarter, 'Q2', 'Q3', 'Q4'}

\item{year}{The year}

\item{api_key}{Your api key}

\item{cache_folder}{The directory to cache results}
}
\value{
A single dataframe with the data
}
\description{
This is a helper function for \code{\link{simfinR_get_fin_statements}}.
It will make calls to the simfin api and save the results in cache.
}
\examples{
\dontrun{

id_companies <- 59265
api_key <- 'YOURAPIHERE'

df_single_fin <- get_single_fin_statement(id_sim = id_companies, type_statement = 'pl',
                                          period_in = 'FY', year = 2018, api_key=api_key,
                                          cache_folder = 'simfim_cache')
}
}
