% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Phenotype.r
\name{build.cov}
\alias{build.cov}
\title{Correlation building}
\usage{
build.cov(df = NULL, mu = rep(0, nrow(Sigma)), Sigma = diag(2), tol = 1e-06)
}
\arguments{
\item{df}{a data frame needing building correlation.}

\item{mu}{means of the variables.}

\item{Sigma}{covariance matrix of variables.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma.}
}
\value{
a data frame with expected correlation
}
\description{
To bulid correlation of variables.
}
\details{
Build date: Oct 10, 2019
Last update: Apr 28, 2022
}
\examples{
df <- data.frame(tr1 = rnorm(100), tr2 = rnorm(100))
df.cov <- build.cov(df)
var(df.cov)
}
\references{
B. D. Ripley (1987) Stochastic Simulation. Wiley. Page 98
}
\author{
Dong Yin and R
}
