% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_meiosis.R
\name{sim_crossovers}
\alias{sim_crossovers}
\title{Simulate crossover locations using the Stahl model}
\usage{
sim_crossovers(L, m = 10, p = 0, obligate_chiasma = FALSE, Lstar = NULL)
}
\arguments{
\item{L}{length of chr in cM}

\item{m}{Interference parameter (\code{m=0} is no interference)}

\item{p}{Proportion of chiasmata from no-interference mechanism
(\code{p=0} gives pure chi-square model)}

\item{obligate_chiasma}{If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis.}

\item{Lstar}{Adjusted chromosome length, if
\code{obligate_chiasma=TRUE}. Calculated if not provided.}
}
\value{
Numeric vector of crossover locations, in cM
}
\description{
Simulate crossover locations on a single meiotic product using the
Stahl model.
}
\details{
Chiasma locations are a superposition of two
processes: a proportion p exhibiting no interference, and a
proportion (1-p) following the chi-square model with interference
parameter m.  Crossover locations are derived by thinning the
chiasma locations with probability 1/2.

Simulations are under the Stahl model with the
interference parameter being an integer. This is an extension of
the chi-square model, but with chiasmata being the superposition of
two processes, one following the chi-square model and the other
exhibiting no interference.
}
\examples{
x <- sim_crossovers(200, 10, 0)
x <- sim_crossovers(200, 10, 0.04)
x <- sim_crossovers(100, 0, 0, obligate_chiasma=TRUE)

}
\references{
Copenhaver, G. P., Housworth, E. A. and Stahl, F. W. (2002) Crossover
interference in arabidopsis.  \emph{Genetics} \bold{160}, 1631--1639.

Foss, E., Lande, R., Stahl, F. W. and Steinberg, C. M. (1993) Chiasma
interference as a function of genetic distance. \emph{Genetics}
\bold{133}, 681--691.

Zhao, H., Speed, T. P. and McPeek, M. S. (1995) Statistical analysis
of crossover interference using the chi-square model.  \emph{Genetics}
\bold{139}, 1045--1056.
}
\keyword{datagen}
