% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geno.R
\name{get_geno}
\alias{get_geno}
\title{Get genotype at a single position}
\usage{
get_geno(xodat, position)
}
\arguments{
\item{xodat}{The sort of detailed genotype/XO data generated by
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}}}

\item{position}{Position (in cM) for which to obtain genotypes}
}
\value{
A numeric matrix with two columns: the maternal and
paternal allele for each individual.
}
\description{
With data on the continuous crossover location information produced by
sim_from_pedigree, grab the genotype at a given position.
}
\examples{
# simulate AIL pedigree
tab <- sim_ail_pedigree(12, 30)
# simulate data from that pedigree
dat <- sim_from_pedigree(tab)
# get genotype at position 30 cM
geno <- get_geno(dat, 30)
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}}, \code{\link[=convert2geno]{convert2geno()}}
}
\keyword{utilities}
