% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsaSpheroids.r
\name{rsa}
\alias{rsa}
\alias{rsa.cylinder}
\alias{rsa.oblate}
\alias{rsa.prolate}
\alias{rsa.sphere}
\title{Random sequential adsorption (RSA)}
\usage{
rsa(S, box, F = NULL, pl = 0, verbose = TRUE)

\method{rsa}{oblate}(S, box, F = NULL, pl = 0, verbose = TRUE)

\method{rsa}{prolate}(S, box, F = NULL, pl = 0, verbose = TRUE)

\method{rsa}{cylinder}(S, box, F = NULL, pl = 0, verbose = TRUE)

\method{rsa}{sphere}(S, box, F = NULL, pl = 0, verbose = TRUE)
}
\arguments{
\item{S}{overlapping geometry system}

\item{box}{simulation box}

\item{F}{secondary phase objects as list}

\item{pl}{integer: if \code{pl>0} give some intermediate results}

\item{verbose}{logical: if \code{verbose=TRUE} (default) show additional information}
}
\value{
list of non-overlapping particles
}
\description{
A simple RSA algorithm
}
\details{
The function generates a non-overlapping configuration of spheres, spheroids or spherocylinders
with respect to periodic boundary conditions by sequentially adding the given objects at new random
positions in the simulation box while keeping their sizes and orientations. If there
is an overlap detected the position is rejected and some new random position is
generated until all particles have put inside or the maximum number of allowed
iterations is reached. This function is most suited for volume fractions less than 0.15.
}
\author{
Felix Ballani, Markus Baaske
}
\references{
J.W. Evans. Random and cooperative sequential adsorption. Rev. Mod. Phys., 65: 1281-1304, 1993.
}

