% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Single_Kc.R
\name{cal_Kcend_for_singleKc}
\alias{cal_Kcend_for_singleKc}
\title{Crop coefficient for the end of the late season stage}
\usage{
cal_Kcend_for_singleKc(RHmine, u2e, Ktable, he)
}
\arguments{
\item{RHmine}{mean value for daily minimum relative humidity during the mid-season
growth stage , for 20 <= RHmine<= 80}

\item{u2e}{mean value for daily wind speed at 2 m height over grass during the mid-
season growth stage (m/s), for 1  <= u2e <= 6}

\item{Ktable}{value for Kc mid taken from Table 12}

\item{he}{mean plant height during the mid-season stage (m) for 0.1 m < h < 10 m}
}
\value{
A value for Kcend value
}
\description{
Typical values for the crop coefficient at the end of the late season growth stage, Kc end, are
 listed in Table 12 for various agricultural crops.
}
\note{
only applied when the tabulated values for Kc end exceed 0.45. The
 equation reduces the Kc end with increasing RHmin. This reduction in Kc end is characteristic
 of crops that are harvested 'green' or before becoming completely dead and dry (Kc end >= 0.45).

 No adjustment is made when Kc end (Table) < 0.45 (Kc end = Kc end (Tab)). When
  crops are allowed to senesce and dry in the field (as evidenced by Kc end < 0.45), u2 and
 RHmin have less effect on Kc end and no adjustment is necessary.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
